<?php

/**
 * WordPress Admin Wizard Setup - Hunnt AI Style
 */
if (!defined('ABSPATH')) {
    exit;
}

// Get current step from URL parameter
$current_step = isset($_GET['step']) ? intval($_GET['step']) : 1;
$max_steps = 4;

// Validate step
if ($current_step < 1 || $current_step > $max_steps) {
    $current_step = 1;
}

// Check if wizard is completed and show step 4 by default
$wizard_completed = get_option('hunnt_ai_wizard_completed', false);
if ($wizard_completed && !isset($_GET['step'])) {
    // If wizard is completed and no step is specified, show step 4 (custom post types)
    $current_step = 4;
}

// Check License key validation for steps 2, 3, and 4 (but allow access if wizard is completed)
$api_key = get_option('hunnt_ai_api_key', '');
if (($current_step > 1) && empty($api_key) && !$wizard_completed) {
    // Redirect to step 1 if License key is not set (only if wizard is not completed)
    wp_redirect(admin_url('admin.php?page=hunnt-ai&step=1'));
    exit;
}

// NOTE: Step 3 form submission is now handled in class-hunnt-ai.php via admin_init hook
// This prevents "headers already sent" errors by processing the form BEFORE any output

// Get plugin URL for assets
$plugin_url = plugin_dir_url(__FILE__);
$admin_url = admin_url('admin.php?page=hunnt-ai');
?>

<link rel="stylesheet" href="<?php echo $plugin_url; ?>assets/css/bootstrap.min.css">
<link rel="stylesheet" href="<?php echo $plugin_url; ?>assets/css/owl.carousel.css">
<link rel="stylesheet" href="<?php echo $plugin_url; ?>assets/css/animate.min.css">
<link rel="stylesheet" href="<?php echo $plugin_url; ?>assets/css/wizard.css">
<link rel="stylesheet" href="<?php echo $plugin_url; ?>assets/css/new-wizard.css">

<div class="wrapper">
    <div class="wizard-content-1 pos-flex clearfix justify-content-between gap-3">
        <div class="steps d-inline-block clearfix">
            <ul class="tablist multisteps-form__progress">
                <li class="multisteps-form__progress-btn <?php echo ($current_step >= 1) ? 'js-active' : ''; ?> <?php echo ($current_step == 1) ? 'current' : ''; ?>">
                    <div class="step-btn-icon-text text-center">
                        <span>1</span>
                        <div class="step-btn-text">
                            <h2 class="text-uppercase"><?php esc_html_e('API Configuration', 'hunnt-ai'); ?></h2>
                        </div>
                    </div>
                </li>
                <li class="multisteps-form__progress-btn <?php echo ($current_step >= 2) ? 'js-active' : ''; ?> <?php echo ($current_step == 2) ? 'current' : ''; ?>">
                    <div class="step-btn-icon-text text-center">
                        <span>2</span>
                        <div class="step-btn-text">
                            <h2 class="text-uppercase"><?php esc_html_e('Basic Settings', 'hunnt-ai'); ?></h2>
                        </div>
                    </div>
                </li>
                <li class="multisteps-form__progress-btn <?php echo ($current_step >= 3) ? 'js-active' : ''; ?> <?php echo ($current_step == 3) ? 'current' : ''; ?>">
                    <div class="step-btn-icon-text text-center">
                        <span>3</span>
                        <div class="step-btn-text">
                            <h2 class="text-uppercase"><?php esc_html_e('Post Types', 'hunnt-ai'); ?></h2>
                        </div>
                    </div>
                </li>
                <li class="multisteps-form__progress-btn <?php echo ($current_step >= 4) ? 'js-active' : ''; ?> <?php echo ($current_step == 4) ? 'current' : ''; ?>">
                    <div class="step-btn-icon-text text-center">
                        <span>4</span>
                        <div class="step-btn-text">
                            <h2 class="text-uppercase"><?php esc_html_e('Complete', 'hunnt-ai'); ?></h2>
                        </div>
                    </div>
                </li>
            </ul>
            <div class="wizard-progress-container">
                <div class="wizard-progress">
                    <span id="progress-text"><?php echo $current_step; ?> of <?php echo $max_steps; ?> <?php esc_html_e('Completed', 'hunnt-ai'); ?></span>
                    <div class="progress">
                        <div class="progress-bar" id="main-progress-bar" style="width: <?php echo ($current_step / $max_steps) * 100; ?>%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="step-inner-content clearfix position-relative">

            <?php
            // Define step information
            $step_info = array(
                1 => array('name' => 'API Configuration', 'description' => 'Setup your License key'),
                2 => array('name' => 'Basic Settings', 'description' => 'Configure your preferences'),
                3 => array('name' => 'Custom Post Types', 'description' => 'View available post types'),
                4 => array('name' => 'Complete', 'description' => 'Setup finished')
            );

            // Get current step info
            $current_step_info = isset($step_info[$current_step]) ? $step_info[$current_step] : $step_info[1];
            $step_name = $current_step_info['name'];
            $step_description = $current_step_info['description'];

            // Include the appropriate step content
            switch ($current_step) {
                case 1:
                    include 'steps/step-1.php';
                    break;
                case 2:
                    include 'steps/step-2.php';
                    break;
                case 3:
                    include 'steps/step-3.php';
                    break;
                case 4:
                    include 'steps/step-4.php';
                    break;
                default:
                    include 'steps/step-1.php';
            }
            ?>

        </div>
    </div>
</div>

<script src="<?php echo $plugin_url; ?>assets/js/jquery-3.3.1.min.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/bootstrap.min.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/popper.min.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/owl.carousel.min.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/form-step.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/jquery.validate.min.js"></script>
<script src="<?php echo $plugin_url; ?>assets/js/main.js"></script>

<script>
    var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
    var currentStep = <?php echo $current_step; ?>;
    var adminUrl = '<?php echo $admin_url; ?>';

    // Simple test function
    function testValidation() {
        console.log('Test function called');
        var apiKey = document.getElementById('hunnt_api_key').value;
        console.log('API License from test:', apiKey);

        if (apiKey) {
            document.getElementById('api-validation-message').innerHTML = '<div class="alert alert-success"><?php esc_html_e('Test successful - License Key:', 'hunnt-ai'); ?> ' + apiKey + '</div>';
        } else {
            document.getElementById('api-validation-message').innerHTML = '<div class="alert alert-danger"><?php esc_html_e('Please enter an License key', 'hunnt-ai'); ?></div>';
        }
    }

    // Dynamic Progress Update Functions
    function updateProgress(step, maxSteps) {
        maxSteps = maxSteps || 4;
        var percentage = (step / maxSteps) * 100;

        // Update progress bar
        var progressBar = document.getElementById('main-progress-bar');
        if (progressBar) {
            progressBar.style.width = percentage + '%';
        }

        // Update progress text
        var progressText = document.getElementById('progress-text');
        if (progressText) {
            progressText.textContent = step + ' of ' + maxSteps + ' Completed';
        }

        console.log('Progress updated:', step + '/' + maxSteps + ' (' + percentage + '%)');
    }

    function animateProgressTo(targetStep, maxSteps) {
        maxSteps = maxSteps || <?php echo $max_steps; ?>;
        var progressBar = document.getElementById('main-progress-bar');
        var progressText = document.getElementById('progress-text');

        if (!progressBar || !progressText) return;

        var currentWidth = parseInt(progressBar.style.width) || 0;
        var targetWidth = (targetStep / maxSteps) * 100;
        var step = (targetWidth - currentWidth) / 20; // 20 animation steps
        var current = currentWidth;

        var animate = function() {
            current += step;
            if ((step > 0 && current >= targetWidth) || (step < 0 && current <= targetWidth)) {
                current = targetWidth;
                progressBar.style.width = current + '%';
                progressText.textContent = targetStep + ' of ' + maxSteps + ' Completed';
                return;
            }
            progressBar.style.width = current + '%';
            requestAnimationFrame(animate);
        };

        animate();
    }

    // Google OAuth Functions for Agency Accounts
    var googleOAuthNonce = '<?php echo wp_create_nonce('hunnt_ai_google_oauth_nonce'); ?>';
    var isAgencyAccount = false;
    var googleTokenVerified = false;

    if (window.hunntAIGoogleOAuth) {
        window.hunntAIGoogleOAuth.noticeTarget = 'none';
        window.hunntAIGoogleOAuth.noticeRenderer = 'inline';
        window.hunntAIGoogleOAuth.useAlerts = false;
        window.hunntAIGoogleOAuth.refreshOnSuccess = false;
    }
    
    function checkGoogleAuthStatus() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'hunnt_ai_check_google_auth_status',
                nonce: googleOAuthNonce
            },
            success: function(res) {
                if (res && res.success && res.data) {
                    isAgencyAccount = res.data.is_agency;
                    googleTokenVerified = res.data.is_verified;
                    
                    if (isAgencyAccount) {
                        $('#google-oauth-section').show();
                        
                        if (googleTokenVerified) {
                            showGoogleVerified();
                            // Don't auto-redirect - let user click Next button manually
                        } else {
                            showGoogleSignIn();
                        }
                    } else {
                        // Not agency, can proceed to next step (will happen when user clicks Next)
                        $('#google-oauth-section').hide();
                    }
                }
            },
            error: function(xhr, status) {
                console.error('Failed to check Google auth status:', status);
                // On error, hide Google section
                $('#google-oauth-section').hide();
            }
        });
    }
    
    function showGoogleSignIn() {
        var $btn = $('#google-signin-btn');
        $('#google-verified-btn').hide();
        $btn.show();
        var originalLabel = $btn.data('original-label');
        if (!originalLabel) {
            originalLabel = $.trim($btn.text()) || '<?php esc_js(__('Sign in with Google', 'hunnt-ai')); ?>';
            $btn.data('original-label', originalLabel);
        }
        $btn.text(originalLabel);
        $btn.prop('disabled', false);
        $('#google-auth-status').html('<p style="color: #856404; margin-bottom: 15px; font-size: 14px;"><?php esc_html_e('Please sign in with Google to continue', 'hunnt-ai'); ?></p>');
    }
    
    function showGoogleVerified() {
        $('#google-signin-btn').hide();
        $('#google-verified-btn').show();
        $('#google-auth-status').html('<p style="color: #28a745; margin-bottom: 15px; font-size: 14px;"><i class="fas fa-check-circle"></i> <?php esc_html_e('Google account successfully connected!', 'hunnt-ai'); ?></p>');
        
        // For agency users: hide validate button, show Next button
        if (isAgencyAccount) {
            $('#validate-api-btn').hide();
            $('#next-step-btn').fadeIn();
        }
    }
    
    $(document).on('hunnt-ai-google-connect-error', function(event, payload) {
        if (currentStep !== 1) {
            return;
        }
        var errorMsg = (payload && payload.message) ? payload.message : '<?php esc_html_e('Failed to initiate Google Sign-In. Please try again.', 'hunnt-ai'); ?>';
        $('#google-auth-status').html('<p style="color: #721c24; margin-bottom: 15px; font-size: 14px;"><i class="fas fa-times-circle"></i> ' + errorMsg + '</p>');
        showGoogleSignIn();
    });

    $(document).on('hunnt-ai-google-callback', function(event, payload) {
        var details = payload || {};
        var success = !!details.success;
        var message = details.message || '';

        $('#google-oauth-section').show();

        if (success) {
            console.log('Google OAuth callback - Success!', details);
            if (details.data) {
                if (typeof details.data.is_agency !== 'undefined') {
                    isAgencyAccount = !!details.data.is_agency;
                } else {
                    isAgencyAccount = true;
                }
                if (typeof details.data.verified !== 'undefined') {
                    googleTokenVerified = !!details.data.verified;
                } else {
                    googleTokenVerified = true;
                }
            } else {
                isAgencyAccount = true;
                googleTokenVerified = true;
            }

            $('#api-validation-message').html('<div class="alert alert-success"><span class="dashicons dashicons-yes"></span> <?php esc_html_e('License key validated successfully!', 'hunnt-ai'); ?></div>');
            showGoogleVerified();

            $.post(ajaxurl, {
                action: 'hunnt_ai_mark_google_verified',
                nonce: googleOAuthNonce
            });
        } else {
            var errorMessage = message || '<?php esc_html_e('Failed to authenticate with Google', 'hunnt-ai'); ?>';
            $('#google-auth-status').html('<p style="color: #721c24; margin-bottom: 15px; font-size: 14px;"><i class="fas fa-times-circle"></i> ' + errorMessage + '</p>');
            googleTokenVerified = false;
            showGoogleSignIn();
        }
    });
</script>

<script>
    jQuery(document).ready(function($) {
        var apiValidated = <?php echo (get_option('hunnt_ai_api_key') && $current_step > 1) ? 'true' : 'false'; ?>;

        // Debug logging
        console.log('Current Step:', currentStep);
        console.log('Ajax URL:', ajaxurl);
        console.log('Admin URL:', adminUrl);
        console.log('jQuery loaded:', typeof $ !== 'undefined');
        console.log('Button exists:', $('.validate-api-btn').length);
        console.log('Input exists:', $('#hunnt_api_key').length);
        console.log('Message div exists:', $('#api-validation-message').length);

        // Add a visual indicator that JS is working
        $('#api-validation-message').html('<div class="alert alert-info"><?php esc_html_e('JavaScript loaded and ready', 'hunnt-ai'); ?></div>');

        // Initialize progress bar based on current step
        updateProgress(currentStep, <?php echo $max_steps; ?>);
        
        // On Step 1: Check if License key exists and check Google auth status
        if (currentStep === 1) {
            var apiKey = $('#hunnt_api_key').val();
            if (apiKey && apiKey.trim() !== '') {
                console.log('License key found on page load, checking Google auth status...');
                checkGoogleAuthStatus();
            }
        }

        // Module check functionality for step 2
        if (currentStep === 2) {
            console.log('Initializing module checks for step 2');

            // Add refresh button for module status if not exists
            if ($('.module-check-section .refresh-modules').length === 0) {
                $('.modules-status-summary').append(
                    '<button type="button" class="btn btn-sm btn-outline-primary refresh-modules" style="margin-left: 10px;">' +
                    '<span class="dashicons dashicons-update"></span> <?php esc_html_e('Refresh Status', 'hunnt-ai'); ?></button>'
                );
            }

            // Handle module status refresh
            $(document).on('click', '.refresh-modules', function(e) {
                e.preventDefault();
                var $btn = $(this);
                var originalText = $btn.html();

                $btn.html('<span class="spinner is-active" style="float:none;margin:0 6px 0 0;"></span> <?php esc_html_e('Checking...', 'hunnt-ai'); ?>').prop('disabled', true);

                // Simulate a brief check (in a real scenario, you might make an AJAX call)
                setTimeout(function() {
                    location.reload(); // Refresh the page to get updated module status
                }, 1000);
            });

            // Automatically check if all modules are OK and show appropriate message
            var missingModules = $('.module-item.module-missing').length;
            var totalModules = $('.module-item').length;

            if (missingModules === 0) {
                console.log('All modules are installed - showing success state');
                $('.modules-status-summary').addClass('modules-all-ok');
            } else {
                console.log('Missing modules detected:', missingModules + '/' + totalModules);
                $('.modules-status-summary').addClass('modules-missing');
            }
        }

        // API validation for step 1 via dedicated AJAX action hunnt_validate_api_key
        $(document).on('click', '.validate-api-btn', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var $message = $('#api-validation-message');
            var apiKey = ($('#hunnt_api_key').val() || '').trim();
            if (!apiKey) {
                $message.html('<div class="alert alert-danger"><span class="dashicons dashicons-warning"></span> <?php esc_html_e('Please enter an License key', 'hunnt-ai'); ?></div>');
                return;
            }
            $btn.prop('disabled', true).data('orig', $btn.html()).html('<span class="spinner is-active" style="float:none;margin:0 6px 0 0;"></span> <?php esc_html_e('Validating...', 'hunnt-ai'); ?>');
            $message.html('<div class="alert alert-info"><span class="dashicons dashicons-clock"></span> <?php esc_html_e('Checking License key validity...', 'hunnt-ai'); ?></div>');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'hunnt_validate_api_key',
                    hunnt_ai_api_key: apiKey, // match handler field name
                    _wpnonce: jQuery('#hunnt-wizard-step1 input[name="_wpnonce"]').val() // reuse existing nonce field
                },
                success: function(res){
                    if (res && res.success) {
                        var responseData = res.data || {};
                        var message = typeof responseData === 'string' ? responseData : (responseData.message || '<?php esc_html_e('License key validated successfully!', 'hunnt-ai'); ?>');
                        $message.html('<div class="alert alert-success"><span class="dashicons dashicons-yes"></span> ' + message + '</div>');
                        
                        // Check if user is agency
                        if (responseData.is_agency) {
                            isAgencyAccount = true;
                            $('#google-oauth-section').show();
                            
                            if (responseData.google_verified) {
                                // Google already connected - show verified status
                                console.log('Google already verified');
                                googleTokenVerified = true;
                                showGoogleVerified();
                                
                                // Hide validate button, show Next button for agency users
                                $('#validate-api-btn').hide();
                                $('#next-step-btn').fadeIn();
                            } else {
                                // Agency user needs to connect Google
                                showGoogleSignIn();
                                // Keep validate button visible, hide Next button
                                $('#validate-api-btn').show();
                                $('#next-step-btn').hide();
                            }
                        } else {
                            // Client user - no Google OAuth needed
                            // Can show Next button immediately for client users if needed
                            // For now, keep validate button visible
                            $('#google-oauth-section').hide();
                        }
                    } else {
                        var msg = (res && res.data) ? res.data : '<?php esc_html_e('Invalid License key', 'hunnt-ai'); ?>';
                        $message.html('<div class="alert alert-danger"><span class="dashicons dashicons-dismiss"></span> ' + msg + '</div>');
                    }
                },
                error: function(xhr, status){
                    $message.html('<div class="alert alert-danger"><span class="dashicons dashicons-dismiss"></span> <?php esc_html_e('Request failed. Please try again.', 'hunnt-ai'); ?> ('+status+')</div>');
                },
                complete: function(){
                    $btn.prop('disabled', false).html($btn.data('orig'));
                }
            });
        });

        // Form submission for step 2
        if (currentStep === 2) {
            $('#hunnt-wizard').on('submit', function(e) {
                e.preventDefault();

                var $submitBtn = $(this).find('button[type="submit"]');
                var $originalText = $submitBtn.html();

                // Show loading state
                $submitBtn.html('<span class="spinner is-active" style="float:none;margin:0 6px 0 0;"></span> <?php esc_html_e('Saving Settings...', 'hunnt-ai'); ?>').prop('disabled', true);

                var formData = $(this).serialize();

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: formData + '&action=hunnt_save_wizard_settings',
                    success: function(response) {
                        if (response.success) {
                            // Show success message briefly before proceeding
                            $submitBtn.html('<?php esc_html_e('Settings Saved!', 'hunnt-ai'); ?>').removeClass('btn-primary').addClass('btn-success');

                            // Animate progress bar to step 3
                            animateProgressTo(3, <?php echo $max_steps; ?>);

                            // Wait 1 second then redirect to step 3
                            setTimeout(function() {
                                window.location.href = adminUrl + '&step=3';
                            }, 1000);
                        } else {
                            alert('<?php esc_html_e('Error saving settings. Please try again.', 'hunnt-ai'); ?>');
                            $submitBtn.html($originalText).prop('disabled', false);
                        }
                    },
                    error: function() {
                        alert('<?php esc_html_e('Network error. Please try again.', 'hunnt-ai'); ?>');
                        $submitBtn.html($originalText).prop('disabled', false);
                    }
                });
            });
        }
    });
</script>