<?php
/**
 * Step 4: Setup Complete - Welcome Message
 */

// Save wizard completion status
update_option('hunnt_ai_wizard_completed', true);

// Get selected posts from previous step (if any)
$selected_posts = get_option('hunnt_ai_selected_posts', array());
$selected_count = count($selected_posts);
$settings_url = admin_url('admin.php?page=hunnt-ai');
?>

<form class="multisteps-form__form" id="hunnt-wizard-step4" method="POST">
    <?php wp_nonce_field('hunnt_wizard_nonce', 'hunnt_wizard_nonce'); ?>
    <div class="form-area">
        <div class="multisteps-form__panel js-active" data-animation="scaleIn">
            <div class="wizard-forms form-step-<?php echo $current_step; ?>">
                <span class="step-no position-absolute">Step <?php echo $current_step; ?> - <?php echo $step_name; ?></span>
                <div class="wizard-inner-box">
                    <div class="inner-title text-center">
                        <div class="success-animation">
                            <div class="check-circle">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <h2><?php esc_html_e('Setup Complete!', 'hunnt-ai'); ?></h2>
                        <p class="lead"><?php esc_html_e('Welcome to Hunnt AI WordPress Plugin', 'hunnt-ai'); ?></p>
                    </div>
                </div>
                
                <div class="completion-details">
                    <div class="text-center">
                        <div class="setup-summary">
                            <p class="success-message"><?php esc_html_e('Your Hunnt AI plugin has been successfully configured and is ready to use.', 'hunnt-ai'); ?></p>
                            
                            <?php if ($selected_count > 0): ?>
                                <div class="selected-posts-info">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i>
                                        <?php echo sprintf(
                                            esc_html__('You have selected %d posts for AI improvement.', 'hunnt-ai'),
                                            $selected_count
                                        ); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <div class="next-steps">
                                <div class="action-cards">
                                    <?php if ($selected_count > 0): ?>
                                        <div class="action-card primary">
                                            <h5><?php esc_html_e('Start Improving Posts', 'hunnt-ai'); ?></h5>
                                            <a href="<?php echo admin_url('admin.php?page=hunnt-ai-improve-articles'); ?>" class="step-4-btn btn-primary btn-lg">
                                                <i class="fas fa-rocket"></i> <?php esc_html_e('Start Now', 'hunnt-ai'); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="action-card secondary">
                                        <h5><?php esc_html_e('Browse Content', 'hunnt-ai'); ?></h5>
                                        <a href="<?php echo admin_url('admin.php?page=hunnt-ai-improve-articles'); ?>" class="step-4-btn btn-outline-primary">
                                            <i class="fas fa-search"></i> <?php esc_html_e('Browse Posts', 'hunnt-ai'); ?>
                                        </a>
                                    </div>
                                    
                                    <div class="action-card secondary">
                                        <h5><?php esc_html_e('Settings', 'hunnt-ai'); ?></h5>
                                        <a href="<?php echo $settings_url; ?>" class="step-4-btn btn-outline-secondary">
                                            <i class="fas fa-cog"></i> <?php esc_html_e('Configure', 'hunnt-ai'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bottom-vector position-absolute">
            <img src="<?php echo $plugin_url; ?>assets/img/sd1.png" alt="">
        </div>
    </div>
</form>
<script>
	setTimeout(function(){ window.location.href = '<?php echo esc_js($settings_url); ?>'; }, 800);
	if (typeof updateProgress === 'function') { updateProgress(4, 4); }
</script>
