<?php
if (!defined('ABSPATH')) {
    exit;
}

$saved_plan = get_option('hunnt_ai_new_posts_plan', []);

$exclude = ['attachment','revision','nav_menu_item','wp_template','wp_template_part'];
$post_types = get_post_types(['public' => true], 'objects');
foreach ($exclude as $ex) { unset($post_types[$ex]); }

// Step 3 form handling is performed in class-hunnt-ai.php via admin_init hook (before any output)
?>

<form class="multisteps-form__form" action="" method="post" id="hunnt-wizard-step3">
    <?php wp_nonce_field('hunnt_ai_step3', 'hunnt_ai_nonce'); ?>
    <div class="form-area">
        <div class="multisteps-form__panel js-active" data-animation="scaleIn">
            <div class="wizard-forms form-step-<?php echo $current_step; ?>">
                <span class="step-no position-absolute"><?php esc_html_e('Step', 'hunnt-ai'); ?> <?php echo $current_step; ?> - <?php echo $step_name; ?></span>
                <div class="wizard-inner-box">
                    <div class="inner-title text-center">
                        <h2><?php esc_html_e('New Articles Plan', 'hunnt-ai'); ?></h2>
                        <p><?php esc_html_e('Choose which post types to auto-create new AI articles for.', 'hunnt-ai'); ?></p>
                        <p><small><?php esc_html_e('Note: To improve existing articles, use the Improve Articles page in plugin settings.', 'hunnt-ai'); ?></small></p>
                    </div>

                    <div id="plan-status" class="modules-status-summary" style="margin-bottom:12px;">
                        <div class="alert alert-info">
                            <span class="dashicons dashicons-info"></span>
                            <?php esc_html_e('Creating new articles requires an active plan.', 'hunnt-ai'); ?>
                            <button type="button" id="get-plan-btn" class="btn btn-sm btn-warning" style="display:none;margin-left:8px;">
                                <span class="dashicons dashicons-awards"></span> <?php esc_html_e('Get a Plan', 'hunnt-ai'); ?>
                            </button>
                        </div>
                    </div>

                    <div class="row">
                        <?php foreach ($post_types as $type_key => $obj):
                            $row = isset($saved_plan[$type_key]) ? $saved_plan[$type_key] : [];
                            $enabled = !empty($row['enabled']);
                            $count = isset($row['count']) ? intval($row['count']) : 0;
                        ?>
                        <div class="col-lg-6 col-md-6">
                            <div class="card" style="padding:16px;margin-bottom:16px;">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h4 style="margin:0;"><?php echo esc_html($obj->labels->name); ?></h4>
                                    <label style="margin:0;">
                                        <input type="checkbox" name="plan_enabled[<?php echo esc_attr($type_key); ?>]" class="plan-enable" data-type="<?php echo esc_attr($type_key); ?>" <?php checked($enabled); ?>>
                                        <?php esc_html_e('Create new posts', 'hunnt-ai'); ?>
                                    </label>
                                </div>
                                <div class="mt-2">
                                    <label>
                                        <?php esc_html_e('How many to create', 'hunnt-ai'); ?>
                                        <input type="number" min="1" step="1" class="regular-text plan-count" name="plan_count[<?php echo esc_attr($type_key); ?>]" value="<?php echo esc_attr($count ?: ''); ?>" placeholder="0" <?php disabled(!$enabled); ?> style="width:120px; margin-left:8px;">
                                    </label>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="actions">
                    <a href="<?php echo admin_url('admin.php?page=hunnt-ai&step=2'); ?>" class="btn btn-secondary"><?php esc_html_e('Back', 'hunnt-ai'); ?></a>
                    <button type="submit" class="btn btn-primary" id="plan-submit"><?php esc_html_e('Next', 'hunnt-ai'); ?></button>
                </div>
            </div>
        </div>
        <div class="bottom-vector position-absolute">
            <img src="<?php echo $plugin_url; ?>assets/img/sd1.png" alt="">
        </div>
    </div>
</form>

<script>
jQuery(function($){
    if (typeof currentStep !== 'undefined' && currentStep === 3) {
        var nonce = '<?php echo wp_create_nonce('hunnt_wizard_nonce'); ?>';
        var pricingUrl = '<?php echo esc_url(hunnt_ai_get_pricing_url()); ?>';

        

        // Enable/disable count by its toggle
        $(document).on('change', '.plan-enable', function(){
            var type = $(this).data('type');
            var on = $(this).is(':checked');
            $('input[name="plan_count['+type+']"]').prop('disabled', !on);
        });

        // Check subscription to gate UI
        $.post(ajaxurl, { action: 'hunnt_ai_check_subscription_status', nonce: nonce }, function(resp){
            var active = !!(resp && resp.success && resp.data && resp.data.active);
            toggleInputs(active);
        }).fail(function(){ toggleInputs(false); });
    }
});
</script>