<form class="multisteps-form__form" id="hunnt-wizard" method="POST">
    <?php wp_nonce_field('hunnt_wizard_nonce', 'hunnt_wizard_nonce'); ?>
    <div class="form-area">
        <div class="multisteps-form__panel js-active" data-animation="scaleIn">
            <div class="wizard-forms form-step-<?php echo $current_step; ?>">
                <span class="step-no position-absolute"><?php esc_html_e('Step', 'hunnt-ai'); ?> <?php echo $current_step; ?> - <?php echo $step_name; ?></span>
                <div class="wizard-inner-box">
                    <div class="inner-title text-center">
                        <h2><?php esc_html_e('Basic Settings Configuration', 'hunnt-ai'); ?></h2>
                        <p><?php esc_html_e('Configure your basic AI assistant settings', 'hunnt-ai'); ?></p>
                    </div>
                    
                    <!-- Module Requirements Check -->
                    <div class="module-check-section">
                        <h3><?php esc_html_e('System Requirements Check', 'hunnt-ai'); ?></h3>
                        <div class="module-requirements">
                            <?php
                            // Check if function exists (safety check)
                            if (function_exists('hunnt_ai_check_modules')) {
                                $missing_modules = hunnt_ai_check_modules();
                            } else {
                                $missing_modules = ['Function not loaded']; // Fallback
                            }
                            
                            $required_modules = [
                                'zlib' => [
                                    'name' => 'Gzip (zlib)',
                                    'description' => esc_html__('Required for compression and data optimization', 'hunnt-ai'),
                                    'status' => !in_array('Gzip (zlib extension)', $missing_modules)
                                ],
                                'curl' => [
                                    'name' => 'cURL',
                                    'description' => esc_html__('Required for API communication', 'hunnt-ai'),
                                    'status' => !in_array('cURL', $missing_modules)
                                ],
                                'mbstring' => [
                                    'name' => 'mbstring',
                                    'description' => esc_html__('Required for multi-byte string handling', 'hunnt-ai'),
                                    'status' => !in_array('mbstring', $missing_modules)
                                ]
                            ];
                            
                            $all_modules_ok = empty($missing_modules) && !in_array('Function not loaded', $missing_modules);
                            ?>
                            
                            <div class="modules-status-summary">
                                <?php if ($all_modules_ok): ?>
                                    <div class="alert alert-success" style="display:flex;align-items:center;justify-content:space-between;gap:10px;flex-wrap:wrap;">
                                        <span><span class="dashicons dashicons-yes"></span> <?php esc_html_e('All required modules are installed and available!', 'hunnt-ai'); ?></span>
                                        <button type="button" class="btn btn-sm btn-outline-primary refresh-modules" id="refresh-modules">
                                            <span class="dashicons dashicons-update"></span> <?php esc_html_e('Refresh Status', 'hunnt-ai'); ?>
                                        </button>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning" style="display:flex;align-items:center;justify-content:space-between;gap:10px;flex-wrap:wrap;">
                                        <span><span class="dashicons dashicons-warning"></span> <?php printf(esc_html__('%d required module(s) are missing. Please contact your hosting provider.', 'hunnt-ai'), count($missing_modules)); ?></span>
                                        <button type="button" class="btn btn-sm btn-outline-primary refresh-modules" id="refresh-modules">
                                            <span class="dashicons dashicons-update"></span> <?php esc_html_e('Refresh Status', 'hunnt-ai'); ?>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="row modules-grid">
                                <?php foreach ($required_modules as $module_key => $module): ?>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="module-item <?php echo $module['status'] ? 'module-ok' : 'module-missing'; ?>">
                                            <div class="module-header">
                                                <span class="module-icon">
                                                    <?php if ($module['status']): ?>
                                                        <span class="dashicons dashicons-yes text-success"></span>
                                                    <?php else: ?>
                                                        <span class="dashicons dashicons-dismiss text-danger"></span>
                                                    <?php endif; ?>
                                                </span>
                                                <h4><?php echo esc_html($module['name']); ?></h4>
                                            </div>
                                            <p class="module-description"><?php echo esc_html($module['description']); ?></p>
                                            <span class="module-status <?php echo $module['status'] ? 'status-ok' : 'status-missing'; ?>">
                                                <?php echo $module['status'] ? esc_html__('Installed', 'hunnt-ai') : esc_html__('Missing', 'hunnt-ai'); ?>
                                            </span>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <?php if (!$all_modules_ok): ?>
                                <div class="module-help-info">
                                    <h4><?php esc_html_e('How to Install Missing Modules', 'hunnt-ai'); ?></h4>
                                    <div class="help-content">
                                        <p><?php esc_html_e('Contact your hosting provider and request the following PHP extensions to be enabled:', 'hunnt-ai'); ?></p>
                                        <ul>
                                            <?php foreach ($missing_modules as $missing): ?>
                                                <li><strong><?php echo esc_html($missing); ?></strong></li>
                                            <?php endforeach; ?>
                                        </ul>
                                        <p><small><?php esc_html_e('Note: The plugin may still work with limited functionality, but we recommend installing all required modules for optimal performance.', 'hunnt-ai'); ?></small></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Technical SEO Check -->
                    <div class="module-check-section" style="margin-top: 30px;">
                        <h3><?php esc_html_e('Technical SEO Status', 'hunnt-ai'); ?></h3>
                        <p><?php esc_html_e('We check and apply performance optimizations: Cache, Minify (CSS/JS/HTML), and Gzip.', 'hunnt-ai'); ?></p>

                        <?php
                        // Initialize technical SEO status before use in the summary alert
                        $initial_status = function_exists('hunnt_ai_get_technical_seo_status') ? hunnt_ai_get_technical_seo_status() : [
                            'cache' => false,
                            'minify_css' => false,
                            'minify_js' => false,
                            'minify_html' => false,
                            'gzip' => false,
                        ];
                        ?>

                        <div class="modules-status-summary" id="tech-seo-summary" style="margin: 10px 0;">
                            <?php $hunnt_all_ok = (array_sum(array_map('intval', $initial_status)) === 5); ?>
                            <div class="alert <?php echo $hunnt_all_ok ? 'alert-success' : 'alert-warning'; ?>" style="display:flex;align-items:center;justify-content:space-between;gap:10px;flex-wrap:wrap;">
                                <span>
                                    <span class="dashicons <?php echo $hunnt_all_ok ? 'dashicons-yes' : 'dashicons-warning'; ?>"></span>
                                    <span id="tech-seo-message">
                                    <?php echo $hunnt_all_ok
                                        ? esc_html__('All technical SEO optimizations are enabled!', 'hunnt-ai')
                                        : esc_html__('Some optimizations are not enabled. We can apply them automatically if your subscription is active.', 'hunnt-ai'); ?>
                                    </span>
                                </span>
                                <span class="tech-seo-actions" style="display:flex;gap:8px;flex-wrap:wrap;">
                                    <button type="button" class="btn btn-sm btn-outline-primary" id="apply-tech-seo">
                                        <span class="dashicons dashicons-admin-tools"></span> <?php esc_html_e('Apply Fixes', 'hunnt-ai'); ?>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-primary" id="refresh-tech-seo">
                                        <span class="dashicons dashicons-update"></span> <?php esc_html_e('Refresh', 'hunnt-ai'); ?>
                                    </button>
                                </span>
                            </div>
                        </div>

                        <div id="tech-seo-status" class="row modules-grid">
                            <?php
                            $features = [
                                'cache' => ['name' => __('Cache', 'hunnt-ai'), 'desc' => __('Send cache headers', 'hunnt-ai')],
                                'minify_css' => ['name' => __('Minify CSS', 'hunnt-ai'), 'desc' => __('Combine and minify CSS', 'hunnt-ai')],
                                'minify_js' => ['name' => __('Minify JS', 'hunnt-ai'), 'desc' => __('Combine and minify JavaScript', 'hunnt-ai')],
                                'minify_html' => ['name' => __('Minify HTML', 'hunnt-ai'), 'desc' => __('Compress HTML output', 'hunnt-ai')],
                                'gzip' => ['name' => __('Gzip', 'hunnt-ai'), 'desc' => __('Enable gzip compression', 'hunnt-ai')],
                            ];
                            foreach ($features as $key => $meta):
                                $ok = !empty($initial_status[$key]);
                            ?>
                            <div class="col-lg-4 col-md-6">
                                <div class="module-item <?php echo $ok ? 'module-ok' : 'module-missing'; ?>" data-feature="<?php echo esc_attr($key); ?>">
                                    <div class="module-header">
                                        <span class="module-icon">
                                            <?php if ($ok): ?>
                                                <span class="dashicons dashicons-yes text-success"></span>
                                            <?php else: ?>
                                                <span class="dashicons dashicons-dismiss text-danger"></span>
                                            <?php endif; ?>
                                        </span>
                                        <h4><?php echo esc_html($meta['name']); ?></h4>
                                    </div>
                                    <p class="module-description"><?php echo esc_html($meta['desc']); ?></p>
                                    <span class="module-status <?php echo $ok ? 'status-ok' : 'status-missing'; ?>">
                                        <?php echo $ok ? esc_html__('Enabled', 'hunnt-ai') : esc_html__('Not Enabled', 'hunnt-ai'); ?>
                                    </span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                    </div>
                </div>
                
                <div class="actions">
                    <a href="<?php echo admin_url('admin.php?page=hunnt-ai&step=1'); ?>" class="btn btn-secondary"><?php esc_html_e('Back', 'hunnt-ai'); ?></a>
                    <button type="submit" name="submit_wizard" class="btn btn-primary"><?php esc_html_e('Next', 'hunnt-ai'); ?></button>
                </div>
            </div>
        </div>
        <div class="bottom-vector position-absolute">
            <img src="<?php echo $plugin_url; ?>assets/img/sd1.png" alt="">
        </div>
    </div>
</form>

<script>
// Technical SEO logic for Step 2
jQuery(function($){
    if (typeof currentStep !== 'undefined' && currentStep === 2) {
        var nonce = '<?php echo wp_create_nonce('hunnt_wizard_nonce'); ?>';
        var pricingUrl = '<?php echo esc_url(hunnt_ai_get_pricing_url()); ?>';
        var subscriptionActive = false;
        function renderTechSeo(status){
            var okCount = 0;
            $('#tech-seo-status .module-item').each(function(){
                var key = $(this).data('feature');
                var ok = !!status[key];
                $(this).toggleClass('module-ok', ok).toggleClass('module-missing', !ok);
                $(this).find('.module-icon').html(ok
                    ? '<span class="dashicons dashicons-yes text-success"></span>'
                    : '<span class="dashicons dashicons-dismiss text-danger"></span>'
                );
                $(this).find('.module-status').toggleClass('status-ok', ok).toggleClass('status-missing', !ok).text(ok ? '<?php echo esc_js(__('Enabled', 'hunnt-ai')); ?>' : '<?php echo esc_js(__('Not Enabled', 'hunnt-ai')); ?>');
                if (ok) okCount++;
            });
            var allOk = okCount === 5;
            var $alert = $('#tech-seo-summary .alert');
            $alert.toggleClass('alert-success', allOk).toggleClass('alert-warning', !allOk);
            $('#tech-seo-message').text(allOk ? '<?php echo esc_js(__('All technical SEO optimizations are enabled!', 'hunnt-ai')); ?>' : '<?php echo esc_js(__('Some optimizations are not enabled. We can apply them automatically if your subscription is active.', 'hunnt-ai')); ?>');
        }

        function fetchStatus(cb){
            $.post(ajaxurl, { action: 'hunnt_ai_get_technical_seo_status', nonce: nonce }, function(resp){
                if (resp && resp.success && resp.data && resp.data.status){
                    renderTechSeo(resp.data.status);
                    if (cb) cb(resp.data.status);
                }
            });
        }

        function applyFixes(features){
            $('#apply-tech-seo').prop('disabled', true).html('<span class="spinner is-active" style="float:none;margin:0 6px 0 0;"></span> <?php echo esc_js(__('Applying...', 'hunnt-ai')); ?>');
            $.post(ajaxurl, { action: 'hunnt_ai_apply_technical_seo', nonce: nonce, features: features }, function(resp){
                if (resp && resp.success){
                    renderTechSeo(resp.data.status || {});
                    $('#apply-tech-seo').html('<span class="dashicons dashicons-yes"></span> <?php echo esc_js(__('Applied', 'hunnt-ai')); ?>');
                    setTimeout(function(){ 
                        $('#apply-tech-seo').prop('disabled', false).html('<span class="dashicons dashicons-admin-tools"></span> <?php echo esc_js(__('Apply Fixes', 'hunnt-ai')); ?>'); 
                    }, 1500);
                } else {
                    var errorMsg = (resp && resp.data) ? resp.data : '<?php echo esc_js(__('Could not apply fixes. Ensure your subscription is active.', 'hunnt-ai')); ?>';
                    console.error('Apply fixes failed:', errorMsg);
                    alert(errorMsg);
                    $('#apply-tech-seo').prop('disabled', false).html('<span class="dashicons dashicons-admin-tools"></span> <?php echo esc_js(__('Apply Fixes', 'hunnt-ai')); ?>');
                }
            }).fail(function(xhr, status, error){
                console.error('Network error while applying fixes:', {xhr: xhr, status: status, error: error});
                alert('<?php echo esc_js(__('Network error while applying fixes', 'hunnt-ai')); ?>');
                $('#apply-tech-seo').prop('disabled', false).html('<span class="dashicons dashicons-admin-tools"></span> <?php echo esc_js(__('Apply Fixes', 'hunnt-ai')); ?>');
            });
        }

        // Refresh button handler
        $('#refresh-tech-seo').on('click', function(e){ 
            e.preventDefault(); 
            fetchStatus(); 
        });

        // Check subscription status
        function checkSubscription(cb){
            $.post(ajaxurl, { action: 'hunnt_ai_check_subscription_status', nonce: nonce }, function(resp){
                subscriptionActive = !!(resp && resp.success && resp.data && resp.data.active);
                if (cb) cb(subscriptionActive);
            }).fail(function(xhr, status, error){ 
                console.error('Subscription check failed:', {xhr: xhr, status: status, error: error});
                if (cb) cb(false); 
            });
        }

        // Apply Fixes button click handler
        $('#apply-tech-seo').on('click', function(e){
            e.preventDefault();
            // First check subscription status
            checkSubscription(function(active){
                if (!active) {
                    // If no active subscription, open pricing page
                    console.log('Opening pricing page:', pricingUrl);
                    window.open(pricingUrl, '_blank');
                    return;
                }
                
                // If subscription is active, check status and apply fixes
                fetchStatus(function(st){
                    var missing = [];
                    ['cache','minify_css','minify_js','minify_html','gzip'].forEach(function(k){ 
                        if(!st[k]) missing.push(k); 
                    });
                    
                    
                    if (missing.length === 0) {
                        $('#tech-seo-message').text('<?php echo esc_js(__('Everything already optimized!', 'hunnt-ai')); ?>');
                        return;
                    }
                    
                    // Apply the missing fixes
                    applyFixes(missing);
                });
            });
        });

        // On page load: fetch status and update button based on subscription
        fetchStatus();
        checkSubscription(function(active){
            if (!active) {
                // Update button for non-subscribers
                $('#apply-tech-seo')
                    .removeClass('btn-outline-primary btn-primary')
                    .addClass('btn-warning')
                    .html('<span class="dashicons dashicons-admin-tools"></span> <?php echo esc_js(__('Fix Now (Premium)', 'hunnt-ai')); ?>');
            } else {
                // Update button for active subscribers
                $('#apply-tech-seo')
                    .removeClass('btn-warning')
                    .addClass('btn-outline-primary')
                    .html('<span class="dashicons dashicons-admin-tools"></span> <?php echo esc_js(__('Apply Fixes', 'hunnt-ai')); ?>');
            }
        });
    }
});
</script>
