<form class="multisteps-form__form" id="hunnt-wizard-step1" method="POST">
    <?php // Add nonce and action for existing handler without altering handler logic ?>
    <input type="hidden" name="action" value="hunnt_ai_save_settings" />
    <?php wp_nonce_field('hunnt_ai_save_settings_nonce'); ?>
    
    <style>
        #google-oauth-section {
            margin-top: 20px;
            text-align: center;
        }
        #google-signin-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background-color: white;
            border: 1px solid #dadce0;
            border-radius: 4px;
            color: #3c4043;
            font-family: 'Google Sans', Roboto, Arial, sans-serif;
            font-size: 14px;
            font-weight: 500;
            padding: 0 12px;
            height: 40px;
            cursor: pointer;
            transition: background-color 0.3s, box-shadow 0.3s;
        }
        #google-signin-btn:hover {
            background-color: #f8f9fa;
            box-shadow: 0 1px 2px 0 rgba(60,64,67,0.3), 0 1px 3px 1px rgba(60,64,67,0.15);
        }
        #google-signin-btn:active {
            background-color: #f1f3f4;
        }
        #google-signin-btn::before {
            content: "";
            display: inline-block;
            width: 18px;
            height: 18px;
            margin-right: 12px;
            background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTgiIGhlaWdodD0iMTgiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj48cGF0aCBkPSJNMTcuNiA5LjJsLS4xLTEuOEg5djMuNGg0LjhDMTMuNiAxMiAxMyAxMyAxMiAxMy42djIuMmgzYTguOCA4LjggMCAwIDAgMi42LTYuNnoiIGZpbGw9IiM0Mjg1RjQiIGZpbGwtcnVsZT0ibm9uemVybyIvPjxwYXRoIGQ9Ik05IDE4YzIuNCAwIDQuNS0uOCA2LTIuMmwtMy0yLjJhNS40IDUuNCAwIDAgMS04LTIuOUgxVjEzYTkgOSAwIDAgMCA4IDV6IiBmaWxsPSIjMzRBODUzIiBmaWxsLXJ1bGU9Im5vbnplcm8iLz48cGF0aCBkPSJNNCAxMC43YTUuNCA1LjQgMCAwIDEgMC0zLjRWNUgxYTkgOSAwIDAgMCAwIDhsMy0yLjN6IiBmaWxsPSIjRkJCQzA1IiBmaWxsLXJ1bGU9Im5vbnplcm8iLz48cGF0aCBkPSJNOSAzLjZjMS4zIDAgMi41LjQgMy40IDEuM0wxNSAyLjNBOSA5IDAgMCAwIDEgNWwzIDIuNGE1LjQgNS40IDAgMCAxIDUtMy43eiIgZmlsbD0iI0VBNDMzNSIgZmlsbC1ydWxlPSJub256ZXJvIi8+PHBhdGggZD0iTTAgMGgxOHYxOEgweiIvPjwvZz48L3N2Zz4=);
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
        }
        #google-verified-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background-color: #28a745;
            border: none;
            border-radius: 4px;
            color: white;
            font-size: 14px;
            font-weight: 500;
            padding: 0 16px;
            height: 40px;
            cursor: default;
        }
        .google-auth-status {
            margin-bottom: 15px;
        }
    </style>
    
    <div class="form-area">
        <div class="multisteps-form__panel js-active" data-animation="scaleIn">
            <div class="wizard-forms form-step-<?php echo $current_step; ?>">
                <span class="step-no position-absolute"><?php esc_html_e('Step', 'hunnt-ai'); ?> <?php echo $current_step; ?> - <?php echo $step_name; ?></span>
                <div class="wizard-inner-box pt-5">
                    <div class="inner-title text-center">
                        <h2><?php esc_html_e('License Key CONFIGURATION', 'hunnt-ai'); ?></h2>
                        <p><?php esc_html_e('Enter your Hunnt AI License key  to connect your WordPress site with our AI services. You can get your License key from your Hunnt AI dashboard.', 'hunnt-ai'); ?></p>
                    </div>
                    
                    <div class="api-config-form">
                        <div class="row justify-content-center">
                            <div class="col-lg-12">
                                <div class="form-input-inner position-relative has-float-label">
                                    <?php
                                    // Use the exact field name expected by hunnt_ai_save_settings_handler
                                    // Keep the original id for existing JS selectors.
                                    ?>
                                    <input type="text" name="hunnt_ai_api_key" id="hunnt_api_key" placeholder="<?php esc_attr_e('Hunnt AI License Key', 'hunnt-ai'); ?>" class="form-control form-control-lg" value="<?php echo esc_attr(get_option('hunnt_ai_api_key', '')); ?>" required>
                                    <label><?php esc_html_e('Hunnt AI License  Key', 'hunnt-ai'); ?> *</label>
                                    <div class="icon-bg text-center">
                                        <i class="fas fa-key"></i>
                                    </div>
                                    <div class="api-validation-message" id="api-validation-message"></div>
                                    
                                    <!-- Google OAuth Section for Agency Accounts -->
                                    <div id="google-oauth-section" style="display: none; margin-top: 20px;">
                                        <div id="google-auth-status" class="google-auth-status"></div>
                                        <button type="button" id="google-signin-btn" class="hunnt-ai-connect-google" data-loading-label="<?php esc_attr_e('Opening Google Sign-In...', 'hunnt-ai'); ?>" style="display: none;">
                                            <?php esc_html_e('Sign in with Google', 'hunnt-ai'); ?>
                                        </button>
                                        <button type="button" id="google-verified-btn" style="display: none;" disabled>
                                            <i class="fas fa-check-circle"></i> <?php esc_html_e('Google Account Connected', 'hunnt-ai'); ?>
                                        </button>
                                    </div>
                                    
                                    <small class="form-text text-muted">
                                        <?php esc_html_e('Your License key is encrypted and stored securely', 'hunnt-ai'); ?>
                                    </small>
                                </div>
                                <div class="api-help-box mt-3">
                                    <h4><?php esc_html_e('Need an License Key?', 'hunnt-ai'); ?></h4>
                                    <p><?php esc_html_e('If you don\'t have an License key yet:', 'hunnt-ai'); ?></p>
                                    <ol>
                                        <li><?php esc_html_e('Visit the Hunnt AI website', 'hunnt-ai'); ?></li>
                                        <li><?php esc_html_e('Create an account or log in', 'hunnt-ai'); ?></li>
                                        <li><?php esc_html_e('Go to your dashboard', 'hunnt-ai'); ?></li>
                                        <li><?php esc_html_e('Copy your License key from the License section', 'hunnt-ai'); ?></li>
                                    </ol>
                                    <a href="https://hunnt.ai/en/client" class="btn btn-info btn-sm" target="_blank">
                                        <i class="fas fa-external-link-alt"></i> <?php esc_html_e('Get License Key', 'hunnt-ai'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="actions justify-content-end">
                    <button type="button" class="validate-api-btn btn btn-info" id="validate-api-btn" style="font-size: 16px; padding: 12px 24px;"><?php esc_html_e('Validate License Key', 'hunnt-ai'); ?></button>
                    <button type="button" class="next-step-btn btn btn-primary" id="next-step-btn" style="font-size: 16px; padding: 12px 24px;" onclick="window.location.href='<?php echo admin_url('admin.php?page=hunnt-ai&step=2'); ?>'">
                        <?php esc_html_e('Next', 'hunnt-ai'); ?> <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </div>
        </div>
        <div class="bottom-vector position-absolute">
            <img src="<?php echo $plugin_url; ?>assets/img/sd1.png" alt="">
        </div>
    </div>
</form>
