<div class="wrap hunnt-ai-admin-wrap">
    <h1><?php echo esc_html__('Hunnt AI Settings', 'hunnt-ai'); ?></h1>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="hunnt_ai_save_settings">
        <?php wp_nonce_field('hunnt_ai_save_settings_nonce'); ?>

        <table class="form-table">
            <tr valign="top">
                <th scope="row">
                    <label for="hunnt_ai_api_key"><?php echo esc_html__('License Key', 'hunnt-ai'); ?></label>
                </th>
                <td>
                    <div style="position: relative; max-width: 400px;">
                        <input
                            required type="password" id="hunnt_ai_api_key" name="hunnt_ai_api_key"
                            value="<?php echo esc_attr(get_option('hunnt_ai_api_key', '')); ?>"
                            class="regular-text"
                            style="padding-right: 40px; border: 1px solid #ccc; border-radius: 4px; height: 34px;">

                        <!-- Eye icon -->
                        <span id="hunnt_ai_toggle" title="Show/Hide License Key">
                            <svg id="hunnt-eye-open" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z" />
                                <circle cx="12" cy="12" r="3" />
                            </svg>

                        </span>
                    </div>
                    <p class="description"><?php echo esc_html__('Enter your Hunnt AI License key here.', 'hunnt-ai'); ?></p>
                </td>
            </tr>


        </table>

        <?php submit_button(__('Save License Key', 'hunnt-ai')); ?>
    </form>
    <hr>

    <!-- Toggle button for post list -->
    <button id="hunnt_ai_toggle_posts" class="button button-secondary">
        <?php echo esc_html__('Show Posts List', 'hunnt-ai'); ?>
    </button>

    <!-- Posts List (hidden by default) -->
    <div id="hunnt_ai_posts_list" style="display:none; margin-top:20px;">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="hunnt_ai_send_posts">
            <?php wp_nonce_field('hunnt_ai_send_posts_nonce'); ?>

            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Select', 'hunnt-ai'); ?></th>
                        <th><?php esc_html_e('Title', 'hunnt-ai'); ?></th>
                        <th><?php esc_html_e('Date', 'hunnt-ai'); ?></th>
                        <th><?php esc_html_e('Improved', 'hunnt-ai'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $posts = get_posts([
                        'numberposts' => 10,
                        'post_type'   => 'post',
                        'post_status' => 'publish',
                    ]);

                    if ($posts) :
                        foreach ($posts as $post) :
                            $improved = get_post_meta($post->ID, '_improved_by_hunnt_ai_api', true);
                    ?>
                            <tr>
                                <!-- Use radio instead of checkbox -->
                                <td>
                                    <input required type="radio" name="hunnt_ai_post" value="<?php echo esc_attr($post->ID); ?>">
                                </td>
                                <td><?php echo esc_html($post->post_title); ?></td>
                                <td><?php echo esc_html(get_the_date('', $post)); ?></td>
                                <td>
                                    <?php if ($improved) : ?>
                                        ✅ <?php echo esc_html($improved); ?>
                                    <?php else : ?>
                                        ❌
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach;
                    else : ?>
                        <tr>
                            <td colspan="4"><?php esc_html_e('No posts found.', 'hunnt-ai'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <p>
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Send Selected to Third Party', 'hunnt-ai'); ?>
                </button>
            </p>
        </form>
    </div>
</div>


<?php if (isset($_GET['hunnt_ai_status'])): ?>
    <?php if ($_GET['hunnt_ai_status'] === 'success'): ?>
        <div class="notice notice-success is-dismissible">
            <p><?php echo $_GET['hunnt_ai_message'] ?></p>
        </div>
    <?php elseif ($_GET['hunnt_ai_status'] === 'invalid'): ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo $_GET['hunnt_ai_message'] ?></p>
        </div>
    <?php else: ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo $_GET['hunnt_ai_message'] ?></p>
        </div>
    <?php endif; ?>
<?php endif; ?>