<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html__('Improve Articles', 'hunnt-ai'); ?></h1>
    
    <?php
    // Get selected articles from session or database
    $selected_articles = get_option('hunnt_ai_selected_articles', array());
    
    if (empty($selected_articles)) {
        ?>
        <div class="notice notice-info">
            <p><?php echo esc_html__('No articles have been selected for improvement yet.', 'hunnt-ai'); ?></p>
            <p>
                <a href="<?php echo admin_url('admin.php?page=hunnt-ai&step=3'); ?>" class="button button-primary">
                    <?php echo esc_html__('Select Articles to Improve', 'hunnt-ai'); ?>
                </a>
            </p>
        </div>
        <?php
    } else {
        ?>
        <div class="notice notice-success">
            <p><?php echo sprintf(esc_html__('You have %d articles selected for improvement.', 'hunnt-ai'), count($selected_articles)); ?></p>
        </div>
        
        <div class="hunnt-ai-improve-articles">
            <h2><?php echo esc_html__('Selected Articles', 'hunnt-ai'); ?></h2>
            
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th scope="col" class="manage-column"><?php echo esc_html__('Title', 'hunnt-ai'); ?></th>
                        <th scope="col" class="manage-column"><?php echo esc_html__('Post Type', 'hunnt-ai'); ?></th>
                        <th scope="col" class="manage-column"><?php echo esc_html__('Status', 'hunnt-ai'); ?></th>
                        <th scope="col" class="manage-column"><?php echo esc_html__('Date', 'hunnt-ai'); ?></th>
                        <th scope="col" class="manage-column"><?php echo esc_html__('Actions', 'hunnt-ai'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($selected_articles as $post_id) {
                        $post = get_post($post_id);
                        if ($post) {
                            $post_type_obj = get_post_type_object($post->post_type);
                            ?>
                            <tr>
                                <td>
                                    <strong>
                                        <a href="<?php echo get_edit_post_link($post->ID); ?>" target="_blank">
                                            <?php echo esc_html($post->post_title); ?>
                                        </a>
                                    </strong>
                                </td>
                                <td><?php echo esc_html($post_type_obj->labels->singular_name); ?></td>
                                <td>
                                    <span class="post-status <?php echo esc_attr($post->post_status); ?>">
                                        <?php echo esc_html(ucfirst($post->post_status)); ?>
                                    </span>
                                </td>
                                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($post->post_date))); ?></td>
                                <td>
                                    <button type="button" class="button button-primary hunnt-ai-improve-btn" data-post-id="<?php echo esc_attr($post->ID); ?>">
                                        <?php echo esc_html__('Improve Now', 'hunnt-ai'); ?>
                                    </button>
                                    <button type="button" class="button hunnt-ai-remove-btn" data-post-id="<?php echo esc_attr($post->ID); ?>">
                                        <?php echo esc_html__('Remove', 'hunnt-ai'); ?>
                                    </button>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>
                </tbody>
            </table>
            
            <div class="hunnt-ai-bulk-actions" style="margin-top: 20px;">
                <button type="button" class="button button-primary" id="hunnt-ai-improve-all">
                    <?php echo esc_html__('Improve All Selected Articles', 'hunnt-ai'); ?>
                </button>
                <button type="button" class="button" id="hunnt-ai-clear-selection">
                    <?php echo esc_html__('Clear Selection', 'hunnt-ai'); ?>
                </button>
                <a href="<?php echo admin_url('admin.php?page=hunnt-ai&step=3'); ?>" class="button">
                    <?php echo esc_html__('Add More Articles', 'hunnt-ai'); ?>
                </a>
            </div>
        </div>
        
        <style>
        .hunnt-ai-improve-articles .post-status {
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .hunnt-ai-improve-articles .post-status.publish {
            background-color: #46b450;
            color: white;
        }
        .hunnt-ai-improve-articles .post-status.draft {
            background-color: #ffb900;
            color: white;
        }
        .hunnt-ai-improve-articles .post-status.private {
            background-color: #826eb4;
            color: white;
        }
        .hunnt-ai-improve-articles .hunnt-ai-improve-btn {
            margin-right: 5px;
        }
        .hunnt-ai-bulk-actions {
            border-top: 1px solid #ddd;
            padding-top: 15px;
        }
        .hunnt-ai-bulk-actions button,
        .hunnt-ai-bulk-actions .button {
            margin-right: 10px;
        }
        </style>
        
        <script>
        jQuery(document).ready(function($) {
            // Improve single article
            $('.hunnt-ai-improve-btn').on('click', function() {
                var postId = $(this).data('post-id');
                var button = $(this);
                
                button.prop('disabled', true).text('<?php echo esc_js(__('Improving...', 'hunnt-ai')); ?>');
                
                // Here you would make an AJAX call to improve the article
                // For now, just simulate success
                setTimeout(function() {
                    button.text('<?php echo esc_js(__('Improved!', 'hunnt-ai')); ?>').removeClass('button-primary').addClass('button-secondary');
                }, 2000);
            });
            
            // Remove article from selection
            $('.hunnt-ai-remove-btn').on('click', function() {
                var postId = $(this).data('post-id');
                var row = $(this).closest('tr');
                
                if (confirm('<?php echo esc_js(__('Are you sure you want to remove this article from the selection?', 'hunnt-ai')); ?>')) {
                    // Here you would make an AJAX call to remove from selection
                    row.fadeOut();
                }
            });
            
            // Improve all articles
            $('#hunnt-ai-improve-all').on('click', function() {
                if (confirm('<?php echo esc_js(__('Are you sure you want to improve all selected articles? This may take some time.', 'hunnt-ai')); ?>')) {
                    $(this).prop('disabled', true).text('<?php echo esc_js(__('Improving All...', 'hunnt-ai')); ?>');
                    
                    // Here you would make an AJAX call to improve all articles
                    // For now, just simulate success
                    setTimeout(function() {
                        $('.hunnt-ai-improve-btn').each(function() {
                            $(this).text('<?php echo esc_js(__('Improved!', 'hunnt-ai')); ?>').removeClass('button-primary').addClass('button-secondary');
                        });
                        $('#hunnt-ai-improve-all').text('<?php echo esc_js(__('All Articles Improved!', 'hunnt-ai')); ?>');
                    }, 5000);
                }
            });
            
            // Clear selection
            $('#hunnt-ai-clear-selection').on('click', function() {
                if (confirm('<?php echo esc_js(__('Are you sure you want to clear all selected articles?', 'hunnt-ai')); ?>')) {
                    // Here you would make an AJAX call to clear selection
                    location.reload();
                }
            });
        });
        </script>
        <?php
    }
    ?>
</div>
