<div class="wrap">
    <h1 class="wp-heading-inline">
        <?php esc_html_e('Improve Posts', 'hunnt-ai'); ?>
        <p><?php esc_html_e('Select articles to improve. Use filters to narrow results.', 'hunnt-ai'); ?></p>
    </h1>
    <?php if (isset($_GET['hunnt_ai_status'])): ?>
        <?php if ($_GET['hunnt_ai_status'] === 'success'): ?>
            <div class="notice notice-success is-dismissible">
                <p><?php echo $_GET['hunnt_ai_message'] ?></p>
            </div>
        <?php elseif ($_GET['hunnt_ai_status'] === 'invalid'): ?>
            <div class="notice notice-error is-dismissible">
                <p><?php echo $_GET['hunnt_ai_message'] ?></p>
                <?php
                echo hunnt_ai_convert_array_to_list($_GET['hunnt_ai_errors']);
                ?>
            </div>
        <?php else: ?>
            <div class="notice notice-error is-dismissible">
                <p><?php echo $_GET['hunnt_ai_message'] ?></p>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <div id="hunnt_ai_posts_list" style=" margin-top:20px;">
        <?php
        $selected = get_option('hunnt_ai_selected_articles', []);
        $all_types = get_post_types(['public' => true], 'objects');

        // Remove unwanted post types
        if (isset($all_types['attachment'])) {
            unset($all_types['attachment']);
        }
        if (isset($all_types['page'])) {
            unset($all_types['page']);
        }

        // Filters
        $filter_type   = isset($_GET['hunnt_type']) ? sanitize_text_field($_GET['hunnt_type']) : 'post';
        $filter_s      = isset($_GET['hunnt_s']) ? sanitize_text_field($_GET['hunnt_s']) : '';
        $filter_status = isset($_GET['hunnt_status']) ? sanitize_text_field($_GET['hunnt_status']) : '';
        $filter_lang   = isset($_GET['hunnt_lang']) ? sanitize_text_field($_GET['hunnt_lang']) : '';
        $filter_improved = isset($_GET['hunnt_improved']) ? sanitize_text_field($_GET['hunnt_improved']) : '';
        $paged         = isset($_GET['hunnt_paged']) ? max(1, intval($_GET['hunnt_paged'])) : 1;
        $per_page      = 10;

        // Base query
        $args = [
            'post_type'      => array_key_exists($filter_type, $all_types) ? $filter_type : 'post',
            's'              => $filter_s,
            'posts_per_page' => $per_page,
            'paged'          => $paged,
            'orderby'        => 'date',
            'order'          => 'DESC',
        ];

        // Post status
        if (in_array($filter_status, ['publish', 'draft', 'private', 'pending', 'future'], true)) {
            $args['post_status'] = $filter_status;
        } else {
            $args['post_status'] = ['publish', 'draft', 'private', 'pending', 'future'];
        }

        // Language filter
        if (!empty($filter_lang)) {
            // Polylang
            if (function_exists('pll_get_the_languages')) {
                $args['lang'] = $filter_lang;
            }
            // WPML
            elseif (defined('ICL_LANGUAGE_CODE')) {
                $args['lang'] = $filter_lang;
            }
        }
        // Improved filter
        if ($filter_improved === 'yes') {
            $args['meta_query'][] = [
                'key'     => '_improved_by_hunnt_ai_api',
                'compare' => 'EXISTS',
            ];
        } elseif ($filter_improved === 'no') {
            $args['meta_query'][] = [
                'key'     => '_improved_by_hunnt_ai_api',
                'compare' => 'NOT EXISTS',
            ];
        }
        $posts = new WP_Query($args);
        ?>
        <form method="get" action="" style="margin-bottom:8px;">
            <input type="hidden" name="page" value="hunnt-ai-improve-articles">

            <!-- Type Filter -->
            <label><?php esc_html_e('Type', 'hunnt-ai'); ?>
                <select name="hunnt_type">
                    <?php foreach ($all_types as $key => $obj): ?>
                        <option value="<?php echo esc_attr($key); ?>" <?php selected($filter_type, $key); ?>>
                            <?php echo esc_html($obj->labels->name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>

            <!-- Status Filter -->
            <label style="margin-left:8px;">
                <?php esc_html_e('Status', 'hunnt-ai'); ?>
                <select name="hunnt_status">
                    <option value=""><?php esc_html_e('Any', 'hunnt-ai'); ?></option>
                    <?php foreach (['publish', 'draft', 'private', 'pending','future'] as $st): ?>
                        <option value="<?php echo esc_attr($st); ?>" <?php selected($filter_status, $st); ?>>
                            <?php echo esc_html(ucfirst($st)); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>

            <!-- Language Filter -->
            <label style="margin-left:8px;">
                <?php esc_html_e('Language', 'hunnt-ai'); ?>
                <select name="hunnt_lang">
                    <option value=""><?php esc_html_e('Any', 'hunnt-ai'); ?></option>
                    <?php
                    $site_languages = hunnt_ai_get_site_languages();
                    foreach ($site_languages as $code => $name) {
                        echo '<option value="'.esc_attr($code).'" '.selected($filter_lang ?? '', $code, false).'>'.esc_html($name).'</option>';
                    }
                    ?>
                </select>
            </label>

            <label style="margin-left:8px;">
                <?php esc_html_e('Improved by Hunnt AI', 'hunnt-ai'); ?>
                <select name="hunnt_improved">
                    <option value=""><?php esc_html_e('Any', 'hunnt-ai'); ?></option>
                    <option value="yes" <?php selected($filter_improved, 'yes'); ?>><?php esc_html_e('Yes', 'hunnt-ai'); ?></option>
                    <option value="no" <?php selected($filter_improved, 'no'); ?>><?php esc_html_e('No', 'hunnt-ai'); ?></option>
                </select>
            </label>
            <!-- Search Filter -->
            <label style="margin-left:8px;">
                <?php esc_html_e('Search', 'hunnt-ai'); ?>
                <input type="search" name="hunnt_s" value="<?php echo esc_attr($filter_s); ?>"/>
            </label>

            <button class="button" style="margin-left:8px;"><?php esc_html_e('Filter', 'hunnt-ai'); ?></button>
        </form>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="hunnt_ai_send_posts">
            <?php wp_nonce_field('hunnt_ai_send_posts_nonce'); ?>

            <table class="widefat fixed striped">
                <thead>
                <tr>
                    <th><?php esc_html_e('Select', 'hunnt-ai'); ?></th>
                    <th><?php esc_html_e('Title', 'hunnt-ai'); ?></th>
                    <th><?php esc_html_e('Date', 'hunnt-ai'); ?></th>
                    <th><?php esc_html_e('Improved', 'hunnt-ai'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php
                if ($posts->have_posts()) :
                    while ($posts->have_posts()) : $posts->the_post();
                        $improved = get_post_meta(get_the_ID(), '_improved_by_hunnt_ai_api', true);
                        $article_send = get_post_meta(get_the_ID(), '_send_to_hunnt_ai_api', true);
                        ?>
                        <tr>
                            <td>
                                <?php if (empty($improved) && empty($article_send)) { ?>
                                    <input type="checkbox" name="hunnt_ai_post[]"
                                           value="<?php echo esc_attr(get_the_ID()); ?>">
                                <?php } ?>
                            </td>
                            <td><?php the_title(); ?></td>
                            <td><?php echo esc_html(get_the_date()); ?></td>
                            <td>
                                <?php
                                if ($improved) { ?>
                                    ✅ <?php echo esc_html($improved); ?><br>
                                    <a href="admin.php?page=hunnt-ai-restore-article&post_id=<?= intval(get_the_ID()) ?>"
                                       class="button button-primary">
                                        <?php esc_html_e('Restore', 'hunnt-ai'); ?>
                                    </a>
                                <?php } elseif ($article_send) { ?>
                                    <?php esc_html_e('Sent to Hunnt AI', 'hunnt-ai'); ?>
                                <?php } else {
                                    echo '❌';
                                }
                                ?>
                            </td>
                        </tr>
                    <?php endwhile;
                    wp_reset_postdata();
                else : ?>
                    <tr>
                        <td colspan="5"><?php esc_html_e('No posts found.', 'hunnt-ai'); ?></td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
            <?php if ($posts->max_num_pages > 1): ?>
                <div class="tablenav">
                    <div class="tablenav-pages">
                        <?php
                        $base_url = remove_query_arg('hunnt_paged');

                        // Prev / Next
                        $prev = $paged > 1 ? add_query_arg('hunnt_paged', $paged - 1, $base_url) : '';
                        $next = $paged < $posts->max_num_pages ? add_query_arg('hunnt_paged', $paged + 1, $base_url) : '';

                        // First / Last
                        $first = $paged > 1 ? add_query_arg('hunnt_paged', 1, $base_url) : '';
                        $last = $paged < $posts->max_num_pages ? add_query_arg('hunnt_paged', $posts->max_num_pages, $base_url) : '';
                        ?>
                        <span class="displaying-num"><?php echo intval($posts->found_posts); ?> <?php esc_html_e('items', 'hunnt-ai'); ?></span>
                        <span class="pagination-links">
                <a class="first-page button<?php echo $first ? '' : ' disabled'; ?>" href="<?php echo esc_url($first ?: 'javascript:void(0)'); ?>">&laquo;</a>
                <a class="prev-page button<?php echo $prev ? '' : ' disabled'; ?>" href="<?php echo esc_url($prev ?: 'javascript:void(0)'); ?>">&lsaquo;</a>
                <span class="paging-input"><?php echo $paged; ?> / <span class="total-pages"><?php echo intval($posts->max_num_pages); ?></span></span>
                <a class="next-page button<?php echo $next ? '' : ' disabled'; ?>" href="<?php echo esc_url($next ?: 'javascript:void(0)'); ?>">&rsaquo;</a>
                <a class="last-page button<?php echo $last ? '' : ' disabled'; ?>" href="<?php echo esc_url($last ?: 'javascript:void(0)'); ?>">&raquo;</a>
            </span>
                    </div>
                </div>
            <?php endif; ?>
            <p>
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Send Selected to Third Party', 'hunnt-ai'); ?>
                </button>
            </p>
        </form>
    </div>
</div>
