<?php
/**
 * API Error Template for Hunnt AI
 * File: templates/error-api.php
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Optional: Pass the error message from the function
$error_message = $error_message ?? esc_html__('Your API key is invalid or could not be verified. Please check your API key and try again.', 'hunnt-ai');
?>

<div class="wrap">
    <h1><?php esc_html_e('Hunnt AI API Error', 'hunnt-ai'); ?></h1>

    <div class="notice notice-error" style="padding: 20px; margin-top: 20px;">
        <p>
            <strong><?php esc_html_e('API Error:', 'hunnt-ai'); ?></strong><br>
            <?php echo esc_html($error_message); ?>
        </p>
    </div>

    <p>
        <a href="<?php echo esc_url(admin_url('admin.php?page=hunnt-ai')); ?>" class="button button-primary">
            <?php esc_html_e('Go Back to Settings', 'hunnt-ai'); ?>
        </a>
    </p>
</div>
