<?php

if (
    isset($site_languages_list) && !empty($site_languages_list)
) { ?>
    <div class="wrap">
        <h2><?php echo esc_html__('Generate New Article', 'hunnt-ai'); ?></h2>

        <form id="generateNewArticleForm" method="post">

            <div class="hunnt-row">
                <div class="hunnt-col main-content-total-articles">
                    <label><?php echo esc_html__('Total Articles', 'hunnt-ai'); ?></label>
                    <p class="hunnt-total-display"><?php echo esc_html($articles_count); ?></p>
                    <input type="hidden" name="total_article" value="<?php echo esc_attr($articles_count); ?>">
                </div>

                <?php foreach ($site_languages_list as $key=>$lang): ?>
                    <div class="hunnt-col">
                        <?php if(isset($lang['name'])) { ?>
                        <label><?php echo esc_html($lang['name']); ?></label>
                        <?php } ?>
                        <input type="number"
                               class="articles-language"
                               min="0"
                               max="<?php echo esc_attr($articles_count); ?>"
                               name="articles[]"
                               data-lang="<?php echo esc_attr($key); ?>"
                               value="0">
                        <input type="hidden" name="selected_articles[<?php echo esc_attr($key); ?>]">
                    </div>
                <?php endforeach; ?>
            </div>

            <label><?php echo esc_html__('Publish Date & Time', 'hunnt-ai'); ?></label><br>

            <div id="publishTypeContainer" class="hunnt-row">
                <label>
                    <input type="radio" name="publish_type" value="manual">
                    <?php echo esc_html__('Manual', 'hunnt-ai'); ?>
                </label>

                <label>
                    <input type="radio" name="publish_type" value="semi_automatic">
                    <?php echo esc_html__('Semi Automatic', 'hunnt-ai'); ?>
                </label>
            </div>

            <!-- Error container -->
            <div id="publishTypeError"></div>

            <!-- Dynamically generated rows -->
            <div id="manual-rows" class="hunnt-mt"></div>

            <!-- Semi Automatic -->
            <div id="semiAutomaticOptions" class="hunnt-row hunnt-mt" style="display:none;">
                <div class="hunnt-col">
                    <label><?php echo esc_html__('Start Date', 'hunnt-ai'); ?></label>
                    <input type="date" name="start_date">
                </div>

                <div class="hunnt-col">
                    <label><?php echo esc_html__('Start Time', 'hunnt-ai'); ?></label>
                    <input type="time" name="start_time">
                </div>

                <div class="hunnt-col">
                    <label><?php echo esc_html__('Repeat Every (Days)', 'hunnt-ai'); ?></label>
                    <input type="number" name="repeat_days" min="1">
                </div>
            </div>

            <div class="hunnt-mt">
                <button type="submit" class="button button-primary">
                    <?php echo esc_html__('Save', 'hunnt-ai'); ?>
                </button>
            </div>

        </form>
    </div>

<?php } else { ?>
    <div class="hunnt-row">
        <div class="hunnt-col main-content-total-articles">
            <?php echo esc_html__('Site settings not set yet', 'hunnt-ai'); ?>
        </div>
    </div>
<?php } ?>
