<?php
/**
 * Plain PHP helper functions shared between the runtime drop-in and the plugin environment.
 */

if (!function_exists('hunnt_ai_static_cache_normalize_host')) {
    function hunnt_ai_static_cache_normalize_host(?string $host): string {
        $host = $host ?? '';
        $host = trim(strtolower($host));

        // Strip port from the host.
        if (strpos($host, ':') !== false) {
            $parts = explode(':', $host);
            $host = $parts[0];
        }

        return $host !== '' ? $host : 'localhost';
    }
}

if (!function_exists('hunnt_ai_static_cache_normalize_uri')) {
    function hunnt_ai_static_cache_normalize_uri(?string $uri): string {
        $uri = $uri ?? '/';
        $uri = trim($uri);
        if ($uri === '') {
            $uri = '/';
        }
        if ($uri[0] !== '/') {
            $uri = '/' . $uri;
        }

        return $uri;
    }
}

if (!function_exists('hunnt_ai_static_cache_detect_variant_from_agent')) {
    function hunnt_ai_static_cache_detect_variant_from_agent(?string $agent): string {
        $agent = strtolower($agent ?? '');

        if ($agent === '') {
            return 'desktop';
        }

        $mobile_indicators = [
            'iphone', 'ipad', 'android', 'iemobile', 'blackberry', 'webos',
            'opera mini', 'mobile', 'silk/', 'kindle', 'fennec', 'bb10'
        ];

        foreach ($mobile_indicators as $indicator) {
            if (strpos($agent, $indicator) !== false) {
                return 'mobile';
            }
        }

        return 'desktop';
    }
}

if (!function_exists('hunnt_ai_static_cache_build_key_raw')) {
    function hunnt_ai_static_cache_build_key_raw(string $host, string $uri, string $variant = 'default'): string {
        return md5(strtolower($host) . '|' . $uri . '|' . strtolower($variant));
    }
}

if (!function_exists('hunnt_ai_static_cache_cookie_matches')) {
    function hunnt_ai_static_cache_cookie_matches(array $cookies, array $patterns): bool {
        if (empty($cookies) || empty($patterns)) {
            return false;
        }

        foreach ($cookies as $name => $value) {
            $name = strtolower((string) $name);
            foreach ($patterns as $pattern) {
                $pattern = strtolower((string) $pattern);
                if ($pattern === '') {
                    continue;
                }
                if (strpos($name, $pattern) === 0) {
                    return true;
                }
            }
        }

        return false;
    }
}
