<?php
/**
 * Hunnt AI static cache drop-in loader.
 */

if (defined('WP_INSTALLING')) {
    return;
}

$helpers = WP_CONTENT_DIR . '/plugins/hunnt-ai-wordpress-plugin/includes/static-cache/plain-helpers.php';
if (is_readable($helpers)) {
    include_once $helpers;
}

$config_file = WP_CONTENT_DIR . '/cache/hunnt-ai/config.php';
$config = [];
if (is_readable($config_file)) {
    $maybe_config = include $config_file;
    if (is_array($maybe_config)) {
        $config = $maybe_config;
    }
}

if (empty($config['enabled'])) {
    return;
}

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
if ($method !== 'GET' && $method !== 'HEAD') {
    return;
}

if (!empty($_GET)) {
    $whitelist = $config['query_whitelist'] ?? [];
    if ($whitelist !== true) {
        $whitelist = is_array($whitelist) ? $whitelist : [];
        foreach (array_keys($_GET) as $key) {
            if (!in_array($key, $whitelist, true)) {
                return;
            }
        }
    }
}

$cookie_patterns = $config['cookie_bypass_patterns'] ?? [];
if (hunnt_ai_static_cache_cookie_matches($_COOKIE ?? [], (array) $cookie_patterns)) {
    return;
}

if (!empty($_SERVER['HTTP_PRAGMA']) && stripos($_SERVER['HTTP_PRAGMA'], 'no-cache') !== false) {
    return;
}

if (!empty($_SERVER['HTTP_CACHE_CONTROL']) && stripos($_SERVER['HTTP_CACHE_CONTROL'], 'no-cache') !== false) {
    return;
}

$host = hunnt_ai_static_cache_normalize_host($_SERVER['HTTP_HOST'] ?? '');
$uri  = hunnt_ai_static_cache_normalize_uri($_SERVER['REQUEST_URI'] ?? '/');
$variant = hunnt_ai_static_cache_detect_variant_from_agent($_SERVER['HTTP_USER_AGENT'] ?? '');
$key = hunnt_ai_static_cache_build_key_raw($host, $uri, $variant);

$cache_root = $config['cache_dir'] ?? (WP_CONTENT_DIR . '/cache/hunnt-ai');
$cache_root = rtrim($cache_root, '/\\');

$html_path = $cache_root . '/pages/' . $key . '.html';
$meta_path = $cache_root . '/meta/' . $key . '.php';
$gzip_path = $html_path . '.gz';

if (!is_readable($html_path) || !is_readable($meta_path)) {
    return;
}

$meta = include $meta_path;
if (!is_array($meta)) {
    return;
}

$expires = isset($meta['expires']) ? (int) $meta['expires'] : 0;
if ($expires > 0 && time() > $expires) {
    return;
}

$status = isset($meta['status']) ? (int) $meta['status'] : 200;
if ($status < 100 || $status > 599) {
    $status = 200;
}

$headers = isset($meta['headers']) && is_array($meta['headers']) ? $meta['headers'] : [];

$accepts_gzip = !empty($_SERVER['HTTP_ACCEPT_ENCODING']) && stripos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false;
$use_gzip = $accepts_gzip && is_readable($gzip_path);

if (!headers_sent()) {
    http_response_code($status);

    foreach ($headers as $name => $value) {
        $name = trim((string) $name);
        if ($name === '') {
            continue;
        }

        if ($use_gzip && strtolower($name) === 'content-length') {
            continue;
        }

        header($name . ': ' . $value, true);
    }

    header('X-Cache-Hit: HunntAI-DropIn');
    if ($use_gzip) {
        header('Content-Encoding: gzip');
    }
}

if ($method === 'HEAD') {
    exit;
}

$path = $use_gzip ? $gzip_path : $html_path;
if (is_readable($path)) {
    readfile($path);
    exit;
}
