<?php

add_action('admin_post_hunnt_ai_save_settings', 'hunnt_ai_save_settings_handler');



function hunnt_ai_save_settings_handler()
{
    // Security check
    if (!isset($_POST['hunnt_ai_api_key']) || !check_admin_referer('hunnt_ai_save_settings_nonce')) {
        wp_die(__('Security check failed', 'hunnt-ai'));
    }
    //set api key to null
    update_option('hunnt_ai_api_key', '');
    $api_key = sanitize_text_field($_POST['hunnt_ai_api_key']);
    $current_lang = hunnt_ai_get_current_language();
    $accept_language = substr($current_lang, 0, 2);
    if (empty($accept_language)) {
        $accept_language = "en";
    }
    
    // Validate License key with your endpoint
    $response = wp_remote_get(HUNNT_AI_ENDPOINT . 'api-key/check', [
        'headers' => [
            'x-api-key' => $api_key,
            'Content-Type' => 'application/json',
            'Accept-Language' => $accept_language
        ],
        'timeout' => 10
    ]);
    $status_code = wp_remote_retrieve_response_code($response);
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    $hunnt_ai_status = "error";
    if (is_wp_error($response)) {
        // Request failed
        $error_message = $response->get_error_message();
        if ($status_code == 401) {
            $hunnt_ai_status = "invalid";
            $error_message = (is_array($data['errors']) && !empty($data['errors'])) ? $data['errors'][0] : $data['errors'];
        }
        wp_redirect(
            add_query_arg(
                array(
                    'hunnt_ai_status' => $hunnt_ai_status,
                    'hunnt_ai_message' => $error_message
                ),
                wp_get_referer()
            )
        );
        exit;
    } else {
        if ($status_code == 401) {
            $hunnt_ai_status = "invalid";
            wp_redirect(
                add_query_arg(
                    array(
                        'hunnt_ai_status' => $hunnt_ai_status,
                        'hunnt_ai_message' => (is_array($data['errors']) && !empty($data['errors'])) ? $data['errors'][0] : $data['errors']
                    ),
                    wp_get_referer()
                )
            );
        } elseif ($status_code == 200) {
            $hunnt_ai_status = "success";
            update_option('hunnt_ai_api_key', $api_key);
            
            // Store user type if provided in response
            if (isset($data['data']['user_type'])) {
                update_option('hunnt_ai_user_type', sanitize_text_field($data['data']['user_type']));
            }
            
            // Store user ID if provided in response (replaces agency_id)
            if (isset($data['data']['user_id'])) {
                update_option('hunnt_ai_user_id', sanitize_text_field($data['data']['user_id']));
            }
            
            // Store Google token verification status in transient if user is agency
            if (isset($data['data']['google_token_verified']) && $data['data']['google_token_verified'] === true) {
                set_transient('hunnt_ai_google_token_verified', true, HOUR_IN_SECONDS);
                set_transient('hunnt_ai_google_token_verified_at', current_time('timestamp'), HOUR_IN_SECONDS);
            } else {
                // Clear transient if not verified
                delete_transient('hunnt_ai_google_token_verified');
                delete_transient('hunnt_ai_google_token_verified_at');
            }
            
            wp_redirect(
                add_query_arg(
                    array(
                        'hunnt_ai_status' => $hunnt_ai_status,
                        'hunnt_ai_message' => (isset($data['message']))  ? $data['message']:''
                    ),
                    wp_get_referer()
                )
            );
        }
    }
    exit;
}

// Save Post Types Plan (create new posts)
add_action('admin_post_hunnt_ai_save_post_types_plan', function(){
    if (!current_user_can('manage_options')) {
        wp_die(__('Unauthorized', 'hunnt-ai'));
    }
    if (!isset($_POST['hunnt_ai_plan_nonce']) || !wp_verify_nonce($_POST['hunnt_ai_plan_nonce'], 'hunnt_ai_save_post_types_plan')) {
        wp_die(__('Security check failed', 'hunnt-ai'));
    }

    $redirect = wp_get_referer() ?: admin_url('admin.php?page=hunnt-ai');

    if (function_exists('hunnt_ai_check_subscription_active')) {
        $sub = hunnt_ai_check_subscription_active();
        if (empty($sub['active'])) {
            wp_redirect(add_query_arg(['hunnt_ai_status' => 'invalid', 'hunnt_ai_message' => __('You need an active plan to save this.', 'hunnt-ai')], $redirect));
            exit;
        }
    }

    $plan = [];
    $enabled = isset($_POST['plan_enabled']) ? (array) $_POST['plan_enabled'] : [];
    $counts  = isset($_POST['plan_count']) ? (array) $_POST['plan_count'] : [];

    $exclude = ['attachment','revision','nav_menu_item','wp_template','wp_template_part'];
    $post_types = get_post_types(['public' => true], 'objects');
    foreach ($exclude as $ex) { unset($post_types[$ex]); }

    foreach ($post_types as $type_key => $obj) {
        $is_enabled = isset($enabled[$type_key]) ? 1 : 0;
        $count = isset($counts[$type_key]) ? max(0, intval($counts[$type_key])) : 0;
        if ($is_enabled && $count > 0) {
            $plan[$type_key] = [ 'enabled' => 1, 'count' => $count ];
        }
    }
    update_option('hunnt_ai_new_posts_plan', $plan);
    wp_redirect(add_query_arg(['hunnt_ai_status' => 'success', 'hunnt_ai_message' => __('Plan saved', 'hunnt-ai')], $redirect));
    exit;
});

// Save Improve Selection
add_action('admin_post_hunnt_ai_save_improve_selection', function(){
    if (!current_user_can('manage_options')) {
        wp_die(__('Unauthorized', 'hunnt-ai'));
    }
    if (!isset($_POST['hunnt_ai_improve_nonce']) || !wp_verify_nonce($_POST['hunnt_ai_improve_nonce'], 'hunnt_ai_save_improve_selection')) {
        wp_die(__('Security check failed', 'hunnt-ai'));
    }
    $redirect = wp_get_referer() ?: admin_url('admin.php?page=hunnt-ai');

    if (function_exists('hunnt_ai_check_subscription_active')) {
        $sub = hunnt_ai_check_subscription_active();
        if (empty($sub['active'])) {
            wp_redirect(add_query_arg(['hunnt_ai_status' => 'invalid', 'hunnt_ai_message' => __('You need an active plan to select articles.', 'hunnt-ai')], $redirect));
            exit;
        }
    }

    $ids = isset($_POST['selected_posts']) ? array_map('intval', (array) $_POST['selected_posts']) : [];
    update_option('hunnt_ai_selected_articles', $ids);
    wp_redirect(add_query_arg(['hunnt_ai_status' => 'success', 'hunnt_ai_message' => __('Selection saved', 'hunnt-ai')], $redirect));
    exit;
});
