<?php
// Enable PHP-level Gzip if zlib exists and output compression is off
add_action('init', function() {
    if (extension_loaded('zlib') && !ini_get('zlib.output_compression')) {
        ini_set('zlib.output_compression', 'On');
        ini_set('zlib.output_compression_level', 6);
    }

    // Ensure ob_gzhandler is used
    if (!headers_sent()) {
        // Prevent conflict with zlib.output_compression
        if (!ini_get('zlib.output_compression')) {
            ob_start('ob_gzhandler');
        }
    } else {
        ob_start();
    }
});