<?php

function hunnt_ai_get_site_timezone()
{
    $tz_string = get_option('timezone_string');
    if ($tz_string) {
        return new DateTimeZone($tz_string);
    }

    // fallback to UTC offset (can be fractional)
    $offset = get_option('gmt_offset'); // e.g., 3 or 5.5
    $hours = (int)$offset;
    $minutes = abs($offset - $hours) * 60;
    $sign = $offset >= 0 ? '+' : '-';

    // Usage
    /*$tz = hunnt_ai_get_site_timezone();
    $dt = new DateTime('now', $tz);
    echo $dt->format('Y-m-d H:i:s T');*/

    // handle fractional offsets
    return new DateTimeZone(sprintf('Etc/GMT%s%d', $sign, abs($hours)));
}

function hunnt_ai_get_post_date_time($params = [])
{
    // 1️⃣ Default datetime = now + 1 hour
    $date = new DateTime();
    $date->modify('+1 hour');
    $default_datetime = $date->format('Y-m-d H:i:s');

    // 2️⃣ Get API params or fallback
    $timezone = (isset($params['timezone']) && !empty($params['timezone'])) ? $params['timezone'] : 'UTC';
    $datetime = (isset($params['datetime']) && !empty($params['datetime'])) ? $params['datetime'] : $default_datetime;

    // 3️⃣ Convert API time to DateTime object in client timezone
    $client_tz = new DateTimeZone($timezone);
    $dt_client = new DateTime($datetime, $client_tz);

    // 4️⃣ Convert to site timezone (optional, can use WP site timezone if needed)
    $site_tz = hunnt_ai_get_site_timezone(); // your helper function
    $dt_site = clone $dt_client;
    $dt_site->setTimezone($site_tz);

    // 5️⃣ Convert to UTC for post_date_gmt (WordPress scheduling)
    $dt_utc = clone $dt_client;
    $dt_utc->setTimezone(new DateTimeZone('UTC'));

    // 6️⃣ Return formatted times
    return [
        'post_date'     => $dt_client->format('Y-m-d H:i:s'), // exact client/API time
        'post_date_gmt' => $dt_utc->format('Y-m-d H:i:s'),    // UTC for WP cron
        'dt_site'       => $dt_site->format('Y-m-d H:i:s'),   // optional, site-local time
        'timezone'      => $timezone,
    ];
}

