<?php
// includes/functions/redirect-handler.php
if (!defined('ABSPATH')) exit;

add_action('template_redirect', function() {
    if (is_singular('post')) {
        global $post;

        // Get redirect URLs
        $redirect_from = get_post_meta($post->ID, '_hunnt_ai_redirect_from', true);
        $redirect_to   = get_post_meta($post->ID, '_hunnt_ai_redirect_to', true);

        // Safety: Only redirect if both exist and are not identical
        if ($redirect_from && $redirect_to && $redirect_from !== $redirect_to) {
            // Current URL the user is visiting
            $current_url = home_url($_SERVER['REQUEST_URI']);

            // Encode URI to handle Arabic/non-Latin slugs
            $current_url_encoded = rawurlencode(urldecode($current_url));
            $redirect_from_encoded = rawurlencode(urldecode($redirect_from));

            // Compare ignoring trailing slashes
            if (untrailingslashit($current_url_encoded) === untrailingslashit($redirect_from_encoded)) {
                wp_redirect($redirect_to, 301); // Permanent redirect
                exit;
            }
        }
    }
});