<?php
function insert_inline_images($html, $images)
{
    try {
        if (empty($images) || !is_array($images)) return $html;

        foreach ($images as $image) {
            if ($image['type'] != "inline") {
                continue;
            }
            // Fix relative src
            $src = (isset($image['url'])) ? $image['url'] : '';
            $alt_text = (isset($image['alt'])) ? $image['alt'] : '';
            $img_tag = "<img width='100%' height='auto' class='hunnt-ai-image-article' src='$src' alt='$alt_text' title='$alt_text' />";
            $comes_after = (isset($image['comes_after'])) ? $image['comes_after'] : '';
            // Insert the image after the first occurrence of comes_after text
            $pos = strpos($html, $comes_after);
            if ($pos !== false) {
                $pos_end = $pos + strlen($comes_after);
                $html = substr_replace($html, $comes_after . $img_tag, $pos, strlen($comes_after));
            }
        }

        return $html;
    } catch (\Exception $exception) {
        return $exception->getMessage();
    }
}