<?php
add_filter('wp_handle_upload', 'myplugin_optimize_image');
function myplugin_optimize_image($file) {
    $image_path = $file['file'];
    $ext = strtolower(pathinfo($image_path, PATHINFO_EXTENSION));

    if (!in_array($ext, ['jpg','jpeg','png'])) {
        return $file; // Only optimize JPG/PNG
    }

    // Use Imagick if available
    if (class_exists('Imagick')) {
        $image = new Imagick($image_path);

        // Strip metadata
        $image->stripImage();

        // Compress
        if ($ext === 'jpg' || $ext === 'jpeg') {
            $image->setImageCompression(Imagick::COMPRESSION_JPEG);
            $image->setImageCompressionQuality(75); // Adjust quality
        } elseif ($ext === 'png') {
            $image->setImageCompressionQuality(8); // PNG compression level 0-9
        }

        $image->writeImage($image_path);
        $image->clear();
        $image->destroy();
    }
    // Fallback to GD
    elseif (function_exists('imagecreatefromjpeg')) {
        if ($ext === 'jpg' || $ext === 'jpeg') {
            $img = imagecreatefromjpeg($image_path);
            imagejpeg($img, $image_path, 75);
            imagedestroy($img);
        } elseif ($ext === 'png') {
            $img = imagecreatefrompng($image_path);
            imagepng($img, $image_path, 8);
            imagedestroy($img);
        }
    }

    // Optional: generate WebP
    if (function_exists('imagewebp')) {
        $webp_path = preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $image_path);
        if ($ext === 'jpg' || $ext === 'jpeg') {
            $img = imagecreatefromjpeg($image_path);
            imagewebp($img, $webp_path, 75);
            imagedestroy($img);
        } elseif ($ext === 'png') {
            $img = imagecreatefrompng($image_path);
            imagewebp($img, $webp_path, 75);
            imagedestroy($img);
        }
    }

    return $file;
}