<?php

/**
 * Check if there is enough disk space to download a batch of images
 *
 * @param array $image_urls Array of image URLs
 * @param int   $buffer_mb  Extra free space to keep (default 50 MB)
 * @return array      True if enough space, error message string if not
 */
function smr_check_disk_space_before_download($image_urls, $buffer_mb = 50) {
    $result = [
        'success'=>true,
        'message'=>''
    ];
    $free_space = disk_free_space(ABSPATH);
    if ($free_space === false) {
        $result = [
            'success'=>false,
            'message'=>"Cannot determine free disk space."
        ];
    }

    $buffer = $buffer_mb * 1024 * 1024; // convert MB to bytes
    $total_size_needed = 0;

    foreach ($image_urls as $image) {
        $size = smr_get_remote_file_size($image['url']);
        if ($size > 0) {
            $total_size_needed += $size;
        }
    }
    if ($total_size_needed + $buffer > $free_space) {
        $result =  [
            'success'=>false,
            'message'=>sprintf(
                "Not enough disk space. Free: %s | Needed: %s (+ buffer %s)",
                size_format($free_space),
                size_format($total_size_needed),
                size_format($buffer)
            )
        ];
    }
    return  $result;
}

/**
 * Get remote file size using headers (Content-Length)
 *
 * @param string $url
 * @return int File size in bytes or 0 if unknown
 */
function smr_get_remote_file_size($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    curl_exec($ch);
    $size = 0;

    if (!curl_errno($ch)) {
        $info = curl_getinfo($ch);
        if (!empty($info['download_content_length']) && $info['download_content_length'] > 0) {
            $size = $info['download_content_length'];
        }
    }
    curl_close($ch);

    return (int) $size;
}