<?php

function hunnt_ai_check_modules() {
    if (!ini_get('zlib.output_compression')) {
        ini_set('zlib.output_compression', 'On');
        ini_set('zlib.output_compression_level', 6); // 1-9
    }
    $missing = [];

    // Check Gzip
    if (!extension_loaded('zlib')) {
        $missing[] = 'Gzip (zlib extension)';
    }

    // Check cURL
    if (!function_exists('curl_version')) {
        $missing[] = 'cURL';
    }

    // Check mbstring
    if (!extension_loaded('mbstring')) {
        $missing[] = 'mbstring';
    }
    return $missing;
}