<?php

function hunnt_ai_check_gzip_active() {
    // 1. PHP-level zlib output compression
    if (ini_get('zlib.output_compression')) {
        return true;
    }

    // 2. Check HTTP headers from remote request
    $response = wp_remote_head(site_url());
    if (!is_wp_error($response)) {
        $headers = wp_remote_retrieve_headers($response);
        if (isset($headers['content-encoding']) && strpos($headers['content-encoding'], 'gzip') !== false) {
            return true;
        }
    }

    return false;
}