<?php

function hunnt_ai_post_response($params = [])
{
    $post_id = (isset($params['post_id'])) ? $params['post_id'] : 0;
    $action = (isset($params['action'])) ? $params['action'] : '';
    $timestamp = current_time('mysql');
    $success = (isset($params['success'])) ? $params['success'] : true;
    if (isset($post_id) && !empty($post_id)) {
        $post = get_post($post_id);
        $permalink = get_permalink($post_id);
    } else {
        $post = null;
        $permalink = null;
    }
    return [
        'post_id' => $post_id,
        'action' => $action,
        'timestamp' => $timestamp,
        'success' => $success,
        'post' => $post,
        'permalink' => $permalink
    ];
}

function hunnt_ai_response($data, $status_code = 200)
{
    // 6️⃣ Return response
    return new WP_REST_Response($data, $status_code);
}

function hunnt_ai_api_response($data)
{
    $result = [
        'success' => true,
        'title' => '',
        'errors' => [],
        'status' => 'invalid',
        'data'=>(isset($data['data'])) ? $data['data'] : []
    ];
    if (isset($data['success'])) {
        $result['success'] = $data['success'];
    }
    if (isset($data['message'])) {
        $result['title'] = $data['message'];
    }
    if (!$result['success'] && isset($data['errors'])) {
        $result['errors'] = $data['errors'];
    }
    if ($result['success']) {
        $result['status'] = "success";
    }
    return $result;
}

function hunnt_ai_convert_array_to_list($array = [])
{
    if (!empty($array)) {
        $template = "<ul>";
        foreach ($array as $item) {
            $template .= "<li>$item</li>";
        }
        $template .= "</ul>";
        return $template;
    }
    return  "";
}