<?php
function hunnt_ai_get_current_language() {
    if ( is_user_logged_in() ) {
        if ( function_exists( 'get_user_locale' ) ) {
            // WP 5.0+
            return get_user_locale();
        } else {
            // Fallback for older WP
            $user = wp_get_current_user();
            if ( isset( $user->locale ) && ! empty( $user->locale ) ) {
                return $user->locale;
            }
        }
    }

    // Guest users or no user locale → fallback to site locale
    return get_locale();
}

function hunnt_ai_get_article_language() {
    // 🔹 Polylang
    if ( function_exists('pll_current_language') ) {
        return pll_current_language();
    }

    // 🔹 WPML
    if ( function_exists('apply_filters') ) {
        $wpml_lang = apply_filters( 'wpml_current_language', null );
        if ( $wpml_lang ) {
            return $wpml_lang;
        }
    }

    // 🔹 Fallback → use your existing locale-based function
    $locale = hunnt_ai_get_current_language(); // returns "en_US" or "ar_SA"
    return substr($locale, 0, 2); // keep only language part
}