<?php

add_action('admin_post_hunnt_ai_send_posts', 'hunnt_ai_send_posts_handler');
function hunnt_ai_send_posts_handler()
{
    if (!current_user_can('manage_options') || !check_admin_referer('hunnt_ai_send_posts_nonce')) {
        wp_die('Unauthorized request');
    }
    if (!empty($_POST['hunnt_ai_post'])) {
        $post_list = $_POST['hunnt_ai_post'];
        $post_ids_with_content = [];
        $posts_no_content = [];
        //check if post list is empty or not
        if (!empty($post_list)) {
            foreach ($post_list as $post_id) {
                $post = get_post(intval($post_id));
                if (empty($post)) {
                    continue;
                }
                if(empty(trim($post->post_content))){
                    $posts_no_content[$post_id] = $post->post_title;
                }
                $post_ids_with_content[$post->ID] = $post;
            }
            //check if some post content is empty
            if(!empty($posts_no_content)){
                $no_post_content_message = __('The content for the below list are empty', 'hunnt-ai')."<br>";
                $errors = [];
                foreach ($posts_no_content as $post_id=>$post_title){
                    $errors[$post_id] = $post_title;
                }
                wp_redirect(
                    add_query_arg(
                        array(
                            'hunnt_ai_status' => 'invalid',
                            'hunnt_ai_message' => $no_post_content_message,
                            'hunnt_ai_errors' => $errors
                        ),
                        wp_get_referer()
                    )
                );
                exit;
            }
            //check if post list is empty
            if (empty($post_ids_with_content)) {
                wp_redirect(add_query_arg([
                    'page' => 'hunnt-ai',
                    'hunnt_ai_status' => 'invalid',
                    'hunnt_ai_message' => urlencode(__('Post list is empty', 'hunnt-ai'))
                ], wp_get_referer()));
                exit;
            } else {
                //send to api
                $api_key = get_option('hunnt_ai_api_key');
                $headers = array(
                    'Authorization' => 'Bearer YOUR_API_TOKEN',
                    'Content-Type' => 'application/json',
                    'x-api-key' => $api_key,
                );
                $body_params = [];
                foreach ($post_ids_with_content as $post_id => $post) {
                    $temp = [
                        'article_content' => $post->post_content,
                        'article_title' => $post->post_title,
                        'article_id' => $post->ID,
                        'categories_list' => hunnt_ai_get_post_categories($post_id),
                        'article_lang' => hunnt_ai_get_post_language($post_id),
                        'article_slug' => urldecode($post->post_name)
                    ];
                    array_push($body_params, $temp);
                }


                $body = [
                    'articles_list' => $body_params
                ];
                $response = wp_remote_post(HUNNT_AI_ENDPOINT . 'article/improve', array(
                    'method' => 'POST',
                    'headers' => $headers,
                    'body' => wp_json_encode($body),
                    'timeout' => 45,
                ));
                $status_code = wp_remote_retrieve_response_code($response);
                $body = wp_remote_retrieve_body($response);
                $data = json_decode($body, true);
                $hunnt_ai_status = "error";
                if (is_wp_error($response)) {
                    // Request failed
                    $error_message = $response->get_error_message();
                    wp_redirect(
                        add_query_arg(
                            array(
                                'hunnt_ai_status' => $hunnt_ai_status,
                                'hunnt_ai_message' => $error_message
                            ),
                            wp_get_referer()
                        )
                    );
                    exit;
                } else {
                    if ($status_code === 401) {
                        wp_redirect(
                            add_query_arg(
                                array(
                                    'hunnt_ai_status' =>'invalid',
                                    'hunnt_ai_message' => esc_html__('Unauthorized: Invalid License key.', 'hunnt-ai'),
                                    'hunnt_ai_errors' => []
                                ),
                                wp_get_referer()
                            )
                        );
                        exit;
                    }
                    if ($status_code === 202) {
                        wp_redirect(
                            add_query_arg(
                                array(
                                    'hunnt_ai_status' => 'invalid',
                                    'hunnt_ai_message' => (isset($data['message'])) ? $data['message'] : '',
                                    'hunnt_ai_errors' => []
                                ),
                                wp_get_referer()
                            )
                        );
                        exit;
                    }
                    if ($status_code === 500) {
                        wp_redirect(
                            add_query_arg(
                                array(
                                    'hunnt_ai_status' => 'invalid',
                                    'hunnt_ai_message' => (isset($data['message'])) ? $data['message'] : '',
                                    'hunnt_ai_errors' => []
                                ),
                                wp_get_referer()
                            )
                        );
                        exit;
                    }
                    if($status_code === 422){
                        $message = '';
                        if (isset($data['errors']) && is_array($data['errors'])) {
                            foreach ($data['errors'] as $error) {
                                $message .= (is_array($error) ? implode(' ', $error) : $error) . ' ';
                            }
                        }
                        wp_redirect(
                            add_query_arg(
                                array(
                                    'hunnt_ai_status' => 'invalid',
                                    'hunnt_ai_message' => $message,
                                    'hunnt_ai_errors' => []
                                ),
                                wp_get_referer()
                            )
                        );
                        exit;
                    }



                    $result = hunnt_ai_api_response($data);
                    //check for update meta
                    if (isset($result['data']) && isset($result['data']['post_ids']) && is_array($result['data']['post_ids'])) {
                        foreach ($result['data']['post_ids'] as $success_post_id){
                            update_post_meta($success_post_id, '_send_to_hunnt_ai_api', 'yes');
                        }
                    }
                    wp_redirect(
                        add_query_arg(
                            array(
                                'hunnt_ai_status' => $result['status'],
                                'hunnt_ai_message' => $result['title'],
                                'hunnt_ai_errors' => $result['errors']
                            ),
                            wp_get_referer()
                        )
                    );
                    exit;
                }
            }

        } else {
            wp_redirect(add_query_arg([
                'hunnt_ai_status' => 'invalid',
                'hunnt_ai_message' => urlencode(__('Post list is empty', 'hunnt-ai'))
            ], wp_get_referer()));
        }

        exit;
    }

    wp_redirect(add_query_arg([
        'hunnt_ai_status' => 'invalid',
        'hunnt_ai_message' => urlencode(__('Post list is empty', 'hunnt-ai'))
    ], wp_get_referer()));
    exit;
}

function hunnt_ai_restore_article($post_id)
{
    if (!defined('WP_POST_REVISIONS')) {
        define('WP_POST_REVISIONS', true);
    }
    $api_url = trailingslashit(HUNNT_AI_ENDPOINT) . "article/restore?article_id=" . intval($post_id);
    $api_key = get_option('hunnt_ai_api_key');

    if (empty($api_key)) {
        wp_redirect(add_query_arg([
            'hunnt_ai_status' => 'error',
            'hunnt_ai_message' => urlencode(__('Missing License key.', 'hunnt-ai'))
        ], admin_url('admin.php')));
        exit;
    }

    $response = wp_remote_get($api_url, [
        'headers' => [
            'x-api-key' => $api_key,
            'Accept' => 'application/json',
        ],
        'timeout' => 20,
    ]);

    if (is_wp_error($response)) {
        wp_redirect(add_query_arg([
            'hunnt_ai_status' => 'error',
            'hunnt_ai_message' => urlencode(__('Request failed. Please try again later.', 'hunnt-ai'))
        ], admin_url('admin.php')));
        exit;
    }

    $status_code = wp_remote_retrieve_response_code($response);
    $body = json_decode(wp_remote_retrieve_body($response), true);

    // 🔐 Unauthorized
    if ($status_code === 401) {
        wp_redirect(add_query_arg([
            'hunnt_ai_status' => 'unauthorized',
            'hunnt_ai_message' => urlencode(__('Unauthorized: Invalid License key.', 'hunnt-ai'))
        ], admin_url('admin.php')));
        exit;
    }

    // ⚠️ Validation failed
    if ($status_code === 422 || $status_code == 500) {
        $message = '';
        if (isset($body['errors']) && is_array($body['errors'])) {
            foreach ($body['errors'] as $error) {
                $message .= (is_array($error) ? implode(' ', $error) : $error) . ' ';
            }
        }
        wp_redirect(add_query_arg([
            'hunnt_ai_status' => 'invalid',
            'hunnt_ai_message' => urlencode(trim($message))
        ], admin_url('admin.php')));
        exit;
    }
    if (empty($post_id) || !is_array($body) || empty($body['data']['article'])) {
        return false;
    }

    $article = $body['data']['article'];

    // 1️⃣ Get the AI-generated URL before restoring
    $ai_url = get_post_meta($post_id, '_hunnt_ai_original_url', true);

    // Update post title and content
    wp_update_post([
        'ID' => $post_id,
        'post_title' => wp_strip_all_tags($article['article_title']),
        'post_content' => wp_kses_post($article['article_content']),
        'post_name'    => $article['article_slug'], // restored slug
    ]);

    // 3️⃣ Get the restored URL (after WordPress updates slug)
    $restored_url = get_permalink($post_id);

    // 4️⃣ Save redirect mapping for 301
    update_post_meta($post_id, '_hunnt_ai_redirect_from', $ai_url);
    update_post_meta($post_id, '_hunnt_ai_redirect_to', $restored_url);

    // Update categories if provided
    if (!empty($article['categories']) && is_array($article['categories'])) {
        $category_ids = [];
        foreach ($article['categories'] as $cat_name) {
            $term = get_term_by('name', $cat_name, 'category');
            if ($term && !is_wp_error($term)) {
                $category_ids[] = intval($term->term_id);
            }
        }
        if (!empty($category_ids)) {
            wp_set_post_categories($post_id, $category_ids);
        }
    }

    // Remove previous "improved" meta
    delete_post_meta($post_id, '_improved_by_hunnt_ai_api');
    delete_post_meta($post_id, '_send_to_hunnt_ai_api');
    delete_post_meta($post_id, '_hunnt_ai_id');

    // ✅ Success
    wp_redirect(add_query_arg([
        'page' => 'hunnt-ai-improve-articles-test-v',
        'hunnt_ai_status' => 'success',
        'hunnt_ai_message' => urlencode(__('Article restored successfully!', 'hunnt-ai'))
    ], admin_url('admin.php')));
    exit;
}
