<?php

// ✅ AJAX: Save articles to API
add_action('wp_ajax_save_generate_articles', function () {
    check_ajax_referer('api_articles_admin_nonce', 'nonce');
// Get submitted data
    $articles = $_POST['articles'] ?? [];
    $max_articles = isset($_POST['max_articles']) ? intval($_POST['max_articles']) : 0;

// ✅ Validate dropdown selection
    if ($max_articles <= 0) {
        wp_send_json_error('Please select the number of articles.');
    }

// ✅ Validate numeric values (only ar/en here, but can be extended for more languages)
    $totals = 0;
    foreach ($articles as $lang => $num) {
        $num = intval($num);
        if ($num < 0) {
            wp_send_json_error("Article numbers for {$lang} cannot be negative.");
        }
        $totals += $num;
    }

// ❌ Validation: must equal exactly $max_articles
    if ($totals !== $max_articles) {
        wp_send_json_error("The total of all language articles must equal {$max_articles}. Currently: {$totals}");
    }
    $articles_list = [];
    if (!empty($articles)) {
        foreach ($articles as $lang => $article_total) {
            $temp = [];
            $temp['number_of_articles'] = $article_total;
            $temp['language'] = $lang;
            $articles_list[] = $temp;
        }
    }
    // ✅ Send to API
    $response = wp_remote_post(HUNNT_AI_ENDPOINT . 'article/generate', [
        'headers' => [
            'Content-Type' => 'application/json',
            'x-api-key' => get_option('hunnt_ai_api_key'),
        ],
        'body' => wp_json_encode([
            'articles_list' => $articles_list,
            'categories_list' => hunnt_ai_categories_list(),
        ]),
    ]);
    if (is_wp_error($response)) {
        wp_send_json_error('Error saving data: ' . $response->get_error_message());
    }

    $status_code = wp_remote_retrieve_response_code($response);
    $body        = wp_remote_retrieve_body($response);
    $data        = json_decode($body, true);
    $result = hunnt_ai_api_response($data);
    //for success
    if($result['success']){
        $message = "Generated saved";
        wp_send_json_success($message);
    }else{
        $message = hunnt_ai_convert_array_to_list($result['errors']);
        wp_send_json_error([
            'message' => $message,
        ], $status_code);
    }



});
