<?php

// ✅ AJAX: Get dropdown values from API
add_action('wp_ajax_get_article_counts', function () {
    check_ajax_referer('api_articles_admin_nonce', 'nonce');

    $api_url = trailingslashit(HUNNT_AI_ENDPOINT) . "article/number/list";
    $api_key = get_option('hunnt_ai_api_key');

    if (empty($api_key)) {
        return hunnt_ai_response([
            'success' => false,
            'message' => esc_html__('Missing License key. Please check plugin settings.', 'hunnt-ai'),
        ], 400);
    }

    $response = wp_remote_get($api_url, [
        'headers' => [
            'x-api-key' => $api_key,
            'Accept'    => 'application/json',
        ],
        'timeout' => 20,
    ]);

    if (is_wp_error($response)) {
        status_header(500);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('API request failed. Please try again later.', 'hunnt-ai'),
        ]);
    }

    $status_code = wp_remote_retrieve_response_code($response);
    $body        = wp_remote_retrieve_body($response);

    if ($status_code === 401) {
        status_header(401);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('Unauthorized: Invalid License key.', 'hunnt-ai'),
        ]);
    }

    $data = json_decode($body, true);

    // Handle invalid JSON response
    if (!is_array($data)) {
        status_header(500);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('Invalid API response format.', 'hunnt-ai'),
        ]);
    }

    // Handle API error response
    if (isset($data['success']) && $data['success'] === false) {
        status_header(422);
        wp_send_json([
            'success' => false,
            'message' => isset($data['message']) ? $data['message'] : esc_html__('API returned an error.', 'hunnt-ai'),
            'errors'  => isset($data['errors']) ? $data['errors'] : [],
        ]);
    }

    // Validate required fields for success response
    if (empty($data['data']['available_options'])) {
        status_header(422);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('Invalid API response: missing available_options.', 'hunnt-ai'),
        ]);
    }
    // ✅ Success - return the data
    wp_send_json([
        'success'             => true,
        'message'             => esc_html__('Article options retrieved successfully.', 'hunnt-ai'),
        'remaining'           => isset($data['data']['remaining']) ? $data['data']['remaining'] : 0,
        'available_options'   => $data['data']['available_options'],
        'available_languages' => isset($data['data']['available_languages']) ? $data['data']['available_languages'] : []
    ]);

});
