<?php

add_action('wp_ajax_agency_generate_article', function () {
    check_ajax_referer('agency_articles_admin_nonce', 'nonce');

    $api_url = trailingslashit(HUNNT_AI_ENDPOINT) . "agency/article/generate";
    $api_key = get_option('hunnt_ai_api_key');

    if (empty($api_key)) {
        wp_send_json_success([
            'status' => 401,
            'message' => 'Articles generated successfully.',
            'data' => []
        ]);
    }

    $articles = $_POST['selected_articles'] ?? [];
    $total_request_articles = 0;
    $articles_list = [];
    $has_number = false;
    if(!empty($articles)){
        foreach ($articles as $lang=>$total){
            if(!empty($total)){
                $has_number = true;
                break;
            }
        }
    }
    if(!$has_number){
        status_header(200);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('You must be select at least one language', 'hunnt-ai'),
        ]);
        exit;
    }
    if(!empty($articles)){
        foreach ($articles as $lang=>$total){
            if(empty($total)){
                continue;
            }
            $total_request_articles+=$total;
            $temp = [
                'number_of_articles'=>$total,
                'language'=>$lang
            ];
            array_push($articles_list,$temp);
        }
    }
    $publish_type = sanitize_text_field($_POST['publish_type'] ?? '');
    $start_date = sanitize_text_field($_POST['start_date'] ?? '');
    $start_time = sanitize_text_field($_POST['start_time'] ?? '');
    $repeat_days = intval($_POST['repeat_days'] ?? 0);
    $publish_datetime = (isset($_POST['publish_datetime']) && is_array($_POST['publish_datetime'])) ? $_POST['publish_datetime']:[];
    // Send request to Laravel API
    $response = wp_remote_post($api_url, [
        'body' => [
            'articles' => $articles_list,
            'publish_type' => $publish_type,
            'start_date' => $start_date,
            'start_time' => $start_time,
            'repeat_days' => $repeat_days,
            'publish_datetime' => $publish_datetime
        ],
        'timeout' => 15,
        'headers' => [
            'x-api-key' => $api_key,
            'Accept'    => 'application/json',
        ],
    ]);
    $status_code = wp_remote_retrieve_response_code($response);
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    if (is_wp_error($response)) {
        status_header(500);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('API request failed. Please try again later.', 'hunnt-ai'),
        ]);
    }
    if ($status_code === 401) {
        status_header(401);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('Unauthorized: Invalid License key.', 'hunnt-ai'),
        ]);
    }
    if ($status_code === 202) {
        status_header(202);
        wp_send_json([
            'success' => false,
            'message' => esc_html__($data['message'], 'hunnt-ai'),
        ]);
    }
    if ($status_code === 500) {
        status_header(500);
        wp_send_json([
            'success' => false,
            'message' => esc_html__($data['message'], 'hunnt-ai'),
        ]);
    }
    if($status_code === 422){
        $message = '';
        if (isset($data['errors']) && is_array($data['errors'])) {
            foreach ($data['errors'] as $error) {
                $message .= (is_array($error) ? implode(' ', $error) : $error) . ' ';
            }
        }
        status_header(422);
        wp_send_json([
            'success' => false,
            'message' => $message,
        ]);
    }
    // Handle invalid JSON response
    if (!is_array($data)) {
        status_header(500);
        wp_send_json([
            'success' => false,
            'message' => esc_html__('Invalid API response format.', 'hunnt-ai'),
        ]);
    }
    if($status_code === 200){
        status_header(200);
        wp_send_json([
            'success' => true,
            'message' => esc_html__('Articles is generate', 'hunnt-ai'),
        ]);
    }
});

