<?php
/**
 * Plugin Name: Hunnt AI
 * Plugin URI: https://hunnt.ai/
 * Description: AI-powered tools and integrations for SEO.
 * Version: 1.0.0
 * Author: Hunnt AI
 * Author URI: https://hunnt.ai/
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: hunnt-ai
 * Domain Path: /languages
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

// Prevent direct file access
if (!defined('WPINC')) {
    die;
}

// Define constants
define('HUNNT_AI_VERSION', '1.0.0');
define('HUNNT_AI_PATH', plugin_dir_path(__FILE__));
define('HUNNT_AI_URL', plugin_dir_url(__FILE__));
define('HUNNT_AI_ENDPOINT', 'https://hunnt.ai/api/v1/');

// Load core files (no Composer dependencies - native PHP implementation)
require_once HUNNT_AI_PATH . 'includes/init/index.php';
require_once HUNNT_AI_PATH . 'includes/main_includes.php';

// Load plugin textdomain for translations
add_action('plugins_loaded', 'hunnt_ai_load_textdomain');
function hunnt_ai_load_textdomain()
{
    load_plugin_textdomain(
        'hunnt-ai',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages/'
    );
}

// Activation & Deactivation hooks
register_activation_hook(__FILE__, array('Hunnt_AI', 'activate'));
register_deactivation_hook(__FILE__, array('Hunnt_AI', 'deactivate'));

// Include all required files
$include_files = [
    'includes/save-api-hunnt-ai.php',
    'includes/article/class-api-insert-article.php',
    'includes/article/api-improve-article.php',
    'includes/article/class-api-improve-article.php',
    'includes/article/class-api-insert-scheduled-article.php',
    'includes/article/api-articles-numbers.php',
    'includes/article/api-generate-article.php',
    'includes/functions/check-modules.php',
    'includes/functions/check-gZip.php',
    'includes/functions/image-optimizer.php',
    'includes/optimization/runtime-minify.php',
    'includes/functions/process_article_images.php',
    'includes/functions/check-site-space.php',
    'includes/functions/notification.php',
    'includes/functions/api_response.php',
    'includes/functions/google-oauth.php',
    'includes/functions/google-oauth-ajax.php',
    'includes/admin/google-oauth-settings.php',
    'includes/helpers/date_time_helper.php',
    'includes/helpers/article_category_helper.php',
    'includes/helpers/technical_seo_helper.php',
    'includes/hook/post_publish.php',
    'includes/functions/sitemap.php',
    'includes/article/agency/agency-generate-articles.php',
];

foreach ($include_files as $file) {
    $full_path = HUNNT_AI_PATH . $file;
    if (file_exists($full_path)) {
        include_once $full_path;
    } else {
        // Log error but don't break the site
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log("Hunnt AI: Missing file - {$file}");
        }
    }
}

// Rewrite rule verification (moved after includes)
add_action('admin_init', function () {
    // Only for admins
    if (!current_user_can('manage_options')) {
        return;
    }

    // Check if our sitemap rewrite rules are working
    if (isset($_GET['check_hunnt_sitemap_rules'])) {
        $rules = get_option('rewrite_rules');
        $found = false;

        foreach ($rules as $rule => $rewrite) {
            if (strpos($rule, 'hunnt-ai') !== false) {
                $found = true;
                break;
            }
        }

        if (!$found) {
            flush_rewrite_rules();
            wp_die('Hunnt AI: Rewrite rules flushed successfully!');
        } else {
            wp_die('Hunnt AI: Rewrite rules are active.');
        }
    }
});

// Initialize plugin
add_action('plugins_loaded', array('Hunnt_AI', 'init'));
add_action('plugins_loaded', array('Hunnt_AI_API', 'init'));

// Add debugging helper (remove in production)
if (defined('WP_DEBUG') && WP_DEBUG) {
    add_action('admin_bar_menu', function ($wp_admin_bar) {
        if (!current_user_can('manage_options'))
            return;

        $wp_admin_bar->add_node([
            'id' => 'hunnt-debug',
            'title' => 'Hunnt Debug',
            'href' => admin_url('?check_hunnt_sitemap_rules=1'),
            'meta' => ['title' => 'Check Hunnt Sitemap Rules']
        ]);
    });
}