jQuery(document).ready(function ($) {

    // Total validation
    $(document).on("input change", ".articles-language", function () {
        let totalAllowed = parseInt($('input[name="total_article"]').val()) || 0;
        let totalEntered = 0;

        $(".articles-language").each(function () {
            totalEntered += parseInt($(this).val()) || 0;
        });

        $(".total-error").remove();

        $(this).next("input[type=hidden]").val($(this).val());

        if (totalEntered > totalAllowed) {
            $(".main-content-total-articles").append(`
                <p class="total-error">
                    Total articles entered (${totalEntered}) cannot exceed allowed (${totalAllowed}).
                </p>
            `);

            $(this).val(totalAllowed);
        }

        // Update manual rows if selected
        if ($("input[name='publish_type']:checked").val() === "manual") {
            $("input[name='publish_type'][value='manual']").trigger("change");
        }
    });

    // Manual / Semi-auto switching
    $(document).on("change", "input[name='publish_type']", function () {
        const type = $(this).val();
        const container = $("#manual-rows");
        container.empty();

        if (type === "manual") {
            $(".articles-language").each(function () {
                let lang = $(this).data("lang");
                let count = parseInt($(this).val()) || 0;

                for (let i = 1; i <= count; i++) {
                    container.append(`
                        <div class="hunnt-row" style="border-bottom:1px solid #ddd;padding:10px 0;">
                            <div class="hunnt-col">
                                <label>${lang.toUpperCase()} Article #${i}</label>
                            </div>
                            <div class="hunnt-col">
                                <input type="datetime-local" name="publish_datetime[${lang}][]" required>
                            </div>
                        </div>
                    `);
                }
            });

            $("#semiAutomaticOptions").hide();
            $("#semiAutomaticOptions input").prop("required", false);
        }

        if (type === "semi_automatic") {
            $("#semiAutomaticOptions").show();
            $("#semiAutomaticOptions input").prop("required", true);
            container.empty();
        }
    });

    // Validation
    $("#generateNewArticleForm").on("submit", function (e) {
        e.preventDefault();

        let publishType = $("input[name='publish_type']:checked").val();
        $("#publishTypeError").empty();

        if (!publishType) {
            $("#publishTypeError").text("Please select a publish type.");
            return;
        }

        // Get the form element
        let form = document.getElementById('generateNewArticleForm');
        let formData = new FormData(form);

        // Add WP action & nonce
        formData.append('action', 'agency_generate_article');
        formData.append('nonce', AgencyGenerateArticle.nonce);

        $.ajax({
            url: AgencyGenerateArticle.ajax_url,
            type: 'POST',
            data: formData,
            processData: false, // Required for FormData
            contentType: false, // Required for FormData
            success: function(res) {
                if(res.success){
                    alert(res.message || 'Success!');
                    location.reload();
                } else {
                    console.error('Error:', res.data);
                    alert('Error: ' + (res.message || 'Unknown error'));
                }
            },
            error: function(err){
                console.error('AJAX error', err);
                alert('AJAX request failed. Check console.');
            }
        });
    });


});